/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons.util;

public class LocConverter {
    public static final double pi = Math.PI;
    private static final double a = 6378245.0;
    private static final double ee = 0.006693421622965943;
    private static final double x_pi = 52.35987755982988;
    private static final double EARTH_RADIUS = 6378.137;

    public static Double[] conversion(Double[] location) {
        double[] doubles = LocConverter.wgs2gcj(new double[]{location[1], location[0]});
        return new Double[]{doubles[1], doubles[0]};
    }

    public static void main(String[] args) throws Exception {
        LocConverter.conversion(new Double[]{121.528739, 38.86514});
    }

    public static double[] wgs2gcj(double[] locs) {
        double wgLat = locs[0];
        double wgLon = locs[1];
        if (LocConverter.outOfChina(wgLat, wgLon)) {
            return null;
        }
        double dLat = LocConverter.transformLat(wgLon - 105.0, wgLat - 35.0);
        double dLon = LocConverter.transformLon(wgLon - 105.0, wgLat - 35.0);
        double radLat = wgLat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        locs[0] = wgLat + dLat;
        locs[1] = wgLon + dLon;
        return locs;
    }

    public static boolean outOfChina(double lat, double lon) {
        return lon < 72.004 || lon > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    private static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static double[] gcj2wgs(double[] locs) {
        int i;
        double a = locs[0];
        double b = locs[1];
        if ((locs = LocConverter.wgs2gcj(locs)) == null) {
            return locs;
        }
        double c = 2.0 * a - locs[0];
        double d = 2.0 * b - locs[1];
        locs[0] = c;
        locs[1] = d;
        for (i = 0; i < 4; ++i) {
            if ((locs = LocConverter.wgs2gcj(locs)) == null) {
                return locs;
            }
            double gap = Math.abs(locs[0] - a) + Math.abs(locs[1] - b);
            locs[0] = c;
            locs[1] = d;
            if (gap < 1.0E-6) {
                return locs;
            }
            if ((locs = LocConverter.search(a, locs, 0)) == null) {
                return locs;
            }
            if ((locs = LocConverter.search(b, locs, 1)) == null) {
                return null;
            }
            c = locs[0];
            d = locs[1];
        }
        if (i >= 4) {
            System.out.println("warn: max loop used");
        }
        return locs;
    }

    private static double[] search(double a, double[] locs, int pos) {
        double c = locs[pos];
        double low = c - 2.0;
        double high = c + 2.0;
        double k = locs[1 - pos];
        double mid = low + (high - low) / 2.0;
        while (high - low >= 1.0E-7) {
            locs[pos] = mid;
            if ((locs = LocConverter.wgs2gcj(locs)) == null) {
                return null;
            }
            locs[1 - pos] = k;
            double v = locs[pos];
            if (v > a) {
                high = mid;
                if (!((mid -= (v - a) * 1.01) <= low)) continue;
                mid = low + (high - low) / 2.0;
                continue;
            }
            if (v < a) {
                low = mid;
                if (!((mid += (a - v) * 1.01) > high)) continue;
                mid = low + (high - low) / 2.0;
                continue;
            }
            locs[pos] = mid;
            return locs;
        }
        locs[pos] = low + (high - low) / 2.0;
        return locs;
    }

    public static double[] gcj2bd(double[] locs) {
        double x = locs[1];
        double y = locs[0];
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * 52.35987755982988);
        locs[1] = z * Math.cos(theta) + 0.0065;
        locs[0] = z * Math.sin(theta) + 0.006;
        return locs;
    }

    public static double[] bd2gcj(double[] locs) {
        double x = locs[1] - 0.0065;
        double y = locs[0] - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        locs[1] = z * Math.cos(theta);
        locs[0] = z * Math.sin(theta);
        return locs;
    }

    public static double[] wgs2bd(double[] locs) {
        if ((locs = LocConverter.wgs2gcj(locs)) != null) {
            locs = LocConverter.gcj2bd(locs);
        }
        return locs;
    }

    public static double[] bd2wgs(double[] locs) {
        if ((locs = LocConverter.bd2gcj(locs)) != null) {
            locs = LocConverter.gcj2wgs(locs);
        }
        return locs;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(Double[] point1, Double[] point2) {
        double radLat1 = LocConverter.rad(point1[0]);
        double radLat2 = LocConverter.rad(point2[0]);
        double a = radLat1 - radLat2;
        double b = LocConverter.rad(point1[1]) - LocConverter.rad(point2[1]);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378.137;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s *= 1000.0;
    }
}

