/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons.util;

import com.v1ok.commons.util.TypeUtil;
import com.v1ok.commons.util.support.DateEditor;
import java.beans.PropertyEditor;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.cglib.beans.BeanMap;

public class BeanUtil {
    public static void populate(Object bean, Map<String, ? extends Object> properties) {
        Validate.notNull(properties, (String)"The properties params at populate method is not null!", (Object[])new Object[0]);
        Validate.notNull((Object)bean, (String)"The bean params at populate method is not null!", (Object[])new Object[0]);
        BeanMap beanMap = BeanMap.create((Object)bean);
        Set set = beanMap.keySet();
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
        simpleTypeConverter.registerCustomEditor(Date.class, (PropertyEditor)new DateEditor());
        for (Object beanProperty : set) {
            String propertyName = beanProperty.toString();
            Class propertyType = beanMap.getPropertyType(propertyName);
            Object propertyValue = properties.get(propertyName);
            Object v = simpleTypeConverter.convertIfNecessary(propertyValue, propertyType);
            beanMap.put(beanProperty, v);
        }
    }

    public static <T> T mapToBean(Class<T> beanClass, Map<String, ?> map) throws IllegalAccessException, InstantiationException {
        Validate.notNull(map, (String)"The map params In mapToBean method is not null!", (Object[])new Object[0]);
        T bean = beanClass.newInstance();
        BeanMap beanMap = BeanMap.create(bean);
        Set set = beanMap.keySet();
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
        Set<Map.Entry<String, ?>> entries = map.entrySet();
        block0: for (Map.Entry<String, ?> entry : entries) {
            String mapKey = StringUtils.replaceChars((String)entry.getKey(), (String)"_", (String)"");
            Object mapValue = entry.getValue();
            if (mapValue == null) continue;
            for (Object beanProperty : set) {
                Object v;
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)beanProperty.toString(), (CharSequence[])new CharSequence[]{mapKey})) continue;
                Class propertyType = beanMap.getPropertyType(beanProperty.toString());
                if (!TypeUtil.isBaseType(propertyType)) {
                    v = simpleTypeConverter.convertIfNecessary(mapValue, propertyType);
                    beanMap.put(beanProperty, v);
                    continue block0;
                }
                v = BeanUtil.mapToBean(propertyType, (Map)mapValue);
                beanMap.put(beanProperty, v);
                continue block0;
            }
        }
        return bean;
    }
}

