/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons.tree;

import com.google.common.collect.Lists;
import com.v1ok.commons.tree.AbstractTreeData;
import com.v1ok.commons.tree.ITreeData;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class MemTreeData<E, ID extends Serializable>
extends AbstractTreeData<E>
implements ITreeData<E, ID> {
    private final List<E> datas;

    public MemTreeData(List<E> datas) {
        this.datas = datas;
    }

    @Override
    public List<E> getAllChildren(ID id) {
        LinkedList value = Lists.newLinkedList();
        List<E> children = this.getChildren(id);
        if (CollectionUtils.isNotEmpty(children)) {
            value.addAll(children);
            for (E e : children) {
                Serializable pid = this.getPId(e);
                List<E> c = this.getAllChildren(pid);
                if (!CollectionUtils.isNotEmpty(c)) continue;
                value.addAll(c);
            }
        }
        return value;
    }

    @Override
    public List<E> getChildren(ID id) {
        LinkedList children = Lists.newLinkedList();
        for (E e : this.datas) {
            Serializable parentId = this.getParentId(e);
            if (!parentId.equals(id)) continue;
            children.add(e);
        }
        this.datas.removeAll(children);
        return children;
    }
}

