/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons.support;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ObjectMapperUtil {
    private static final String DEFAULT_DATE_FORMATS = "yyyy-MM-dd HH:mm";
    private static ObjectMapper OM = null;
    private static final Lock LOCK = new ReentrantLock(true);

    public static ObjectMapper getSingleton() {
        return ObjectMapperUtil.getSingleton(DEFAULT_DATE_FORMATS);
    }

    public static ObjectMapper getSingleton(String DATE_FORMATS) {
        if (OM == null) {
            LOCK.lock();
            try {
                if (OM == null) {
                    OM = ObjectMapperUtil.getInstens(DATE_FORMATS);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return OM;
    }

    public static ObjectMapper getInstens() {
        return ObjectMapperUtil.getInstens(DEFAULT_DATE_FORMATS);
    }

    public static ObjectMapper getInstens(String DATE_FORMATS) {
        ObjectMapper om = new ObjectMapper();
        om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        om.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        om.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        return om;
    }
}

