/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth.interceptor;

import com.v1ok.auth.AuthProperties;
import com.v1ok.auth.AuthVerify;
import com.v1ok.auth.Generator;
import com.v1ok.auth.IUserContext;
import com.v1ok.auth.interceptor.AbstractInterceptor;
import com.v1ok.commons.HeadCode;
import com.v1ok.commons.RequestValue;
import com.v1ok.commons.annotation.AuthorityRequired;
import com.v1ok.commons.impl.RestResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuthorityRequiredInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthorityRequiredInterceptor.class);
    final AuthProperties properties;

    public AuthorityRequiredInterceptor(AuthProperties properties) {
        this.properties = properties;
    }

    @Around(value="@annotation(com.v1ok.commons.annotation.AuthorityRequired) && @annotation(authority)")
    public Object interceptor(ProceedingJoinPoint point, AuthorityRequired authority) throws Throwable {
        RequestValue<?> value = this.getRequestValue((JoinPoint)point);
        IUserContext userContext = this.getUserContext(value);
        if (StringUtils.isNotEmpty((CharSequence)authority.permissionCode()) && !userContext.getPermissions().contains(authority.permissionCode())) {
            return RestResponse.builder().error(HeadCode.NO_PERMISSION);
        }
        return this.exec(userContext, point);
    }

    @Override
    protected IUserContext parseToken(String token) {
        String interfaceKey = this.properties.getInterfaceKey();
        return AuthVerify.parseUserContextAccessToken((String)token, (String)interfaceKey);
    }

    @Override
    protected String generateToken(IUserContext context) {
        String interfaceKey = this.properties.getInterfaceKey();
        return Generator.accessToken((IUserContext)context, (String)interfaceKey);
    }
}

