/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth.interceptor;

import com.v1ok.auth.AuthProperties;
import com.v1ok.auth.AuthVerify;
import com.v1ok.auth.Generator;
import com.v1ok.auth.IUserContext;
import com.v1ok.auth.interceptor.AbstractInterceptor;
import com.v1ok.commons.RequestValue;
import com.v1ok.commons.annotation.ServiceAuth;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ServiceAuthInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ServiceAuthInterceptor.class);
    final AuthProperties properties;

    public ServiceAuthInterceptor(AuthProperties properties) {
        this.properties = properties;
    }

    @Around(value="@annotation(com.v1ok.commons.annotation.ServiceAuth) && @annotation(serviceAuth)")
    public Object Interceptor(ProceedingJoinPoint point, ServiceAuth serviceAuth) throws Throwable {
        RequestValue<?> value = this.getRequestValue((JoinPoint)point);
        IUserContext userContext = this.getUserContext(value);
        return this.exec(userContext, point);
    }

    @Override
    protected IUserContext parseToken(String token) {
        String serviceKey = this.properties.getServiceKey();
        return AuthVerify.parseUserContextToken((String)token, (String)serviceKey);
    }

    @Override
    protected String generateToken(IUserContext context) {
        String serviceKey = this.properties.getServiceKey();
        return Generator.token((IUserContext)context, (String)serviceKey);
    }
}

