/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons.impl;

import com.v1ok.commons.Head;
import com.v1ok.commons.HeadCode;
import com.v1ok.commons.IRestResponse;
import com.v1ok.commons.impl.AbstractMappingJacksonValue;
import java.util.HashMap;
import java.util.Map;

public class RestResponse<V>
extends AbstractMappingJacksonValue<V>
implements IRestResponse<V> {
    private final Map<String, Object> value = new HashMap<String, Object>();

    private RestResponse(Object body) {
        super(body);
        this.value.put("head", new Head());
        this.value.put("body", body);
        this.setValue(this.value);
    }

    public static <T> RestResponse<T> builder() {
        RestResponse response = new RestResponse(null);
        response.success(true);
        return response;
    }

    public static <T> RestResponse<T> builder(T body) {
        RestResponse response = new RestResponse(body);
        response.success(true);
        return response;
    }

    public RestResponse<V> success(boolean isSuccess) {
        Head head = this.getHead();
        if (isSuccess) {
            head.setCode(HeadCode.SUCCESS.getCode());
            head.setMsg(HeadCode.SUCCESS.getMsg());
        } else {
            head.setCode(HeadCode.ERROR.getCode());
            head.setMsg(HeadCode.ERROR.getMsg());
        }
        return this;
    }

    @Override
    public RestResponse<V> data(V data) {
        this.getContext().put("body", data);
        return this;
    }

    public RestResponse<V> serializeData(V data) {
        this.getContext().put("body", data);
        return this;
    }

    public RestResponse<V> message(String message) {
        this.getHead().setMsg(message);
        return this;
    }

    public RestResponse<V> error() {
        return this.error(HeadCode.ERROR);
    }

    public RestResponse<V> error(HeadCode headCode) {
        this.getHead().setCode(headCode.getCode());
        this.getHead().setMsg(headCode.getMsg());
        return this;
    }

    @Override
    public Head getHead() {
        return (Head)this.getContext().get("head");
    }

    public void setHead(Head head) {
        this.getContext().put("head", head);
    }

    @Override
    public V getBody() {
        return (V)this.getContext().get("body");
    }

    private Map<String, Object> getContext() {
        return (Map)this.getValue();
    }

    public String toString() {
        return "RestResponse(value=" + this.value + ")";
    }
}

