/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class OpenIdUtil {
    private static final String VERSION = "$01";
    private static final String CHARACTER_SEQUENCE = ".-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char[] CHARS = ".-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String createOpenId(String userId, String securityKey) {
        Validate.notBlank((CharSequence)userId, (String)"The userId must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        Validate.isTrue((boolean)OpenIdUtil.validate(userId), (String)"userId not at chars '.-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'", (Object[])new Object[0]);
        char[] chars = userId.toCharArray();
        StringBuilder openIdBuilder = new StringBuilder(VERSION);
        for (char c : chars) {
            int indexOfChars = ArrayUtils.indexOf((char[])CHARS, (char)c);
            int i = (indexOfChars + OpenIdUtil.offset(securityKey)) % CHARS.length;
            openIdBuilder.append(CHARS[i]);
        }
        return openIdBuilder.toString();
    }

    public static String parseOpenId(String openId, String securityKey) {
        Validate.notBlank((CharSequence)openId, (String)"The openId must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        openId = StringUtils.substring((String)openId, (int)VERSION.length());
        Validate.isTrue((boolean)OpenIdUtil.validate(openId), (String)"openId not at chars '.-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'", (Object[])new Object[0]);
        char[] chars = openId.toCharArray();
        StringBuilder openIdBuilder = new StringBuilder();
        for (char c : chars) {
            int indexOfChars = ArrayUtils.indexOf((char[])CHARS, (char)c);
            int i = (indexOfChars + CHARS.length - OpenIdUtil.offset(securityKey)) % CHARS.length;
            openIdBuilder.append(CHARS[i]);
        }
        return openIdBuilder.toString();
    }

    private static int offset(String securityKey) {
        char[] chars;
        int offset = 0;
        for (char c : chars = securityKey.toCharArray()) {
            offset += c;
            offset %= chars.length;
        }
        return offset;
    }

    private static boolean validate(String str) {
        char[] chars;
        for (char c : chars = str.toCharArray()) {
            if (ArrayUtils.contains((char[])CHARS, (char)c)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String userId = "2B346DACBC21000";
        String securityKey = "MkIwRjlBNDU1NDIxMDAw";
        System.out.println(userId);
        String openId = OpenIdUtil.createOpenId(userId, securityKey);
        System.out.println(openId);
        String parseOpenId = OpenIdUtil.parseOpenId(openId, securityKey);
        System.out.println(parseOpenId);
    }
}

