/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth.interceptor;

import com.v1ok.auth.IUserContext;
import com.v1ok.commons.ContextHolder;
import com.v1ok.commons.Head;
import com.v1ok.commons.IRestResponse;
import com.v1ok.commons.RequestValue;
import com.v1ok.commons.exception.AuthorityException;
import com.v1ok.commons.impl.DefaultContext;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractInterceptor.class);
    public static final String HTTP_HEAD_TOKEN = "X-token";
    public static final String TOKEN = "token";

    protected abstract IUserContext parseToken(String var1);

    protected abstract String generateToken(IUserContext var1);

    protected Object exec(IUserContext userContext, ProceedingJoinPoint point) {
        Head head = this.getHead((JoinPoint)point);
        if ((this.isGet() || this.isDelete()) && head != null) {
            head.setTenantId(userContext.getTenantId());
        }
        DefaultContext context = new DefaultContext(userContext);
        ContextHolder.getHolder().set(context);
        try {
            IRestResponse restResponse;
            Object proceed = point.proceed();
            if (proceed instanceof IRestResponse && (restResponse = (IRestResponse)proceed).getHead().getCode() == 200) {
                String token = this.generateToken(userContext);
                restResponse.getHead().setToken(token);
            }
            Object object = proceed;
            return object;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            ContextHolder.getHolder().remove();
        }
    }

    protected <T> T getArg(JoinPoint pjp, Class<T> clazz) {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            Class<?> argClass;
            if (arg == null || !ClassUtils.isAssignable(argClass = arg.getClass(), clazz)) continue;
            return (T)arg;
        }
        return null;
    }

    protected RequestValue<?> getRequestValue(JoinPoint point) {
        return this.getArg(point, RequestValue.class);
    }

    protected Head getHead(JoinPoint point) {
        return this.getArg(point, Head.class);
    }

    protected IUserContext getUserContext(RequestValue<?> requestValue) {
        Head head;
        String token;
        if (requestValue == null) {
            requestValue = new RequestValue();
        }
        if (StringUtils.isEmpty((CharSequence)(token = this.getToken(head = requestValue.getHead())))) {
            throw new AuthorityException();
        }
        IUserContext userContext = this.parseToken(token);
        if (userContext == null) {
            throw new AuthorityException();
        }
        head.setTenantId(userContext.getTenantId());
        return userContext;
    }

    protected String getRequestMethod() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        return request.getMethod();
    }

    protected boolean isGet() {
        return "GET".equals(this.getRequestMethod());
    }

    protected boolean isDelete() {
        return "DELETE".equals(this.getRequestMethod());
    }

    protected String getToken(Head head) {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        if (request != null) {
            String token = request.getHeader(HTTP_HEAD_TOKEN);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                return token;
            }
            token = request.getParameter(TOKEN);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                return token;
            }
            if (head != null) {
                token = head.getToken();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{token})) {
                    return token;
                }
            }
        }
        return null;
    }
}

