/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.commons.exception.handler;

import com.v1ok.commons.HeadCode;
import com.v1ok.commons.IRestResponse;
import com.v1ok.commons.exception.AuthorityException;
import com.v1ok.commons.exception.OperationException;
import com.v1ok.commons.impl.RestResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public IRestResponse<?> exceptionHandler(Exception exception) {
        log.error("\u670d\u52a1\u5668\u8fd0\u884c\u65f6\u51fa\u9519\u672a\u77e5\u9519\u8bef", (Throwable)exception);
        return RestResponse.builder().error(HeadCode.ERROR).message(exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={OperationException.class})
    @ResponseBody
    public IRestResponse<?> exceptionHandler(OperationException exception) {
        log.error("\u670d\u52a1\u5668\u8fd0\u884c\u65f6\u51fa\u9519", (Throwable)exception);
        return RestResponse.builder().error(HeadCode.BAD_REQUEST).message(exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={AuthorityException.class})
    @ResponseBody
    public IRestResponse<?> authorityExceptionHandler(AuthorityException exception) {
        log.error("\u9700\u8981\u767b\u5f55\u6821\u9a8c\u6ca1\u901a\u8fc7\u3002", (Throwable)exception);
        return RestResponse.builder().error(HeadCode.UN_AUTHORIZED);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException exception, HttpHeaders headers, HttpStatus status, WebRequest request) {
        List errors;
        BindingResult exceptions = exception.getBindingResult();
        if (exceptions.hasErrors() && !(errors = exceptions.getAllErrors()).isEmpty()) {
            FieldError fieldError = (FieldError)errors.get(0);
            return ResponseEntity.ok().body(RestResponse.builder().error(HeadCode.BAD_REQUEST).message(fieldError.getField() + ":" + fieldError.getDefaultMessage()));
        }
        log.error("\u53c2\u6570\u6821\u9a8c\u51fa\u9519", (Throwable)exception);
        return ResponseEntity.badRequest().body((Object)exception.getMessage());
    }
}

