/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.modelmapper.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.modelmapper.spi.ValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetReader
implements ValueReader<ResultSet> {
    private static final Logger log = LoggerFactory.getLogger(ResultSetReader.class);

    public Object get(ResultSet source, String memberName) {
        Object object = null;
        try {
            object = source.getObject(memberName);
        }
        catch (SQLException e) {
            log.error("get object value from ResultSet is error!", (Throwable)e);
        }
        return object;
    }

    public ValueReader.Member<ResultSet> getMember(ResultSet source, String memberName) {
        final Object value = this.get(source, memberName);
        if (value == null) {
            return null;
        }
        return new ValueReader.Member<ResultSet>(value.getClass()){

            public Object get(ResultSet source, String memberName) {
                return value;
            }
        };
    }

    public Collection<String> memberNames(ResultSet source) {
        try {
            ResultSetMetaData metaData = source.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String> memberNames = new ArrayList<String>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                String columnLabel = metaData.getColumnLabel(i);
                memberNames.add(columnLabel);
            }
            return memberNames;
        }
        catch (SQLException e) {
            log.error("get ResultSetMetaData is error!", (Throwable)e);
            return null;
        }
    }
}

