/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth.impl;

import com.v1ok.auth.IAppContext;
import com.v1ok.auth.IUserContext;
import com.v1ok.auth.impl.DefaultAppContext;
import com.v1ok.auth.impl.DefaultUserContext;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContextParse {
    private static final Logger log = LoggerFactory.getLogger(AbstractContextParse.class);

    protected IUserContext parseUserContext(String token, String securityKey) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(DigestUtils.md5((String)securityKey)).parseClaimsJws(token).getBody();
            String userId = (String)claims.get("userId", String.class);
            String tenantId = (String)claims.get("tenantId", String.class);
            String positions = (String)claims.get("positions", String.class);
            List permissions = (List)claims.get("permissions", List.class);
            return DefaultUserContext.builder().userId(userId).tenantId(tenantId).positions(positions).permissions(permissions).build();
        }
        catch (Exception e) {
            log.error("parse token is error.", (Throwable)e);
            return null;
        }
    }

    protected IAppContext parseAppContext(String token, String securityKey) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(DigestUtils.md5((String)securityKey)).parseClaimsJws(token).getBody();
            String appId = (String)claims.get("appId", String.class);
            securityKey = (String)claims.get("securityKey", String.class);
            return DefaultAppContext.builder().appId(appId).securityKey(securityKey).build();
        }
        catch (Exception e) {
            log.error("parse accessToken is error.", (Throwable)e);
            return null;
        }
    }
}

