/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class AESUtil {
    private static final String AES = "AES";
    private static final String PKCS5_PADDING = "AES/CBC/PKCS5Padding";

    public static String encryptStr(String content, String password) {
        byte[] encrypt = AESUtil.encrypt(content, password);
        return Base64.encodeBase64URLSafeString((byte[])encrypt);
    }

    public static String encryptStr(String content, String password, Charset charset) {
        byte[] encrypt = AESUtil.encrypt(content, password, charset);
        return Base64.encodeBase64URLSafeString((byte[])encrypt);
    }

    public static byte[] encrypt(String content, String password) {
        return AESUtil.encrypt(content, password, StandardCharsets.UTF_8);
    }

    public static byte[] encrypt(String content, String password, Charset charset) {
        KeyHandler keyHandler = KeyHandler.create(password);
        byte[] byteContent = content.getBytes(charset);
        Cipher cipher = Cipher.getInstance(PKCS5_PADDING);
        cipher.init(1, (Key)keyHandler.key, keyHandler.iv);
        return cipher.doFinal(byteContent);
    }

    public static String decryptStr(String content, String password) {
        return AESUtil.decryptStr(content, password, StandardCharsets.UTF_8);
    }

    public static String decryptStr(String content, String password, Charset charset) {
        byte[] bytes = Base64.decodeBase64((String)content);
        byte[] decrypt = AESUtil.decrypt(bytes, password);
        return new String(decrypt, charset);
    }

    public static byte[] decrypt(byte[] content, String password) {
        KeyHandler keyHandler = KeyHandler.create(password);
        Cipher cipher = Cipher.getInstance(PKCS5_PADDING);
        cipher.init(2, (Key)keyHandler.key, keyHandler.iv);
        return cipher.doFinal(content);
    }

    private static class KeyHandler {
        SecretKeySpec key;
        IvParameterSpec iv;

        public static KeyHandler create(String password) {
            String md5Hex = DigestUtils.md5Hex((String)password);
            String keyStr = StringUtils.substring((String)md5Hex, (int)0, (int)16);
            String ivValue = StringUtils.substring((String)md5Hex, (int)16, (int)32);
            KeyHandler keyHandler = new KeyHandler();
            keyHandler.key = new SecretKeySpec(keyStr.getBytes(StandardCharsets.US_ASCII), AESUtil.AES);
            keyHandler.iv = new IvParameterSpec(ivValue.getBytes(StandardCharsets.US_ASCII));
            return keyHandler;
        }

        public SecretKeySpec getKey() {
            return this.key;
        }

        public IvParameterSpec getIv() {
            return this.iv;
        }

        public void setKey(SecretKeySpec key) {
            this.key = key;
        }

        public void setIv(IvParameterSpec iv) {
            this.iv = iv;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyHandler)) {
                return false;
            }
            KeyHandler other = (KeyHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SecretKeySpec this$key = this.getKey();
            SecretKeySpec other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            IvParameterSpec this$iv = this.getIv();
            IvParameterSpec other$iv = other.getIv();
            return !(this$iv == null ? other$iv != null : !this$iv.equals(other$iv));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SecretKeySpec $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            IvParameterSpec $iv = this.getIv();
            result = result * 59 + ($iv == null ? 43 : $iv.hashCode());
            return result;
        }

        public String toString() {
            return "AESUtil.KeyHandler(key=" + this.getKey() + ", iv=" + this.getIv() + ")";
        }
    }
}

