/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth.impl;

import com.v1ok.auth.IAppContext;
import com.v1ok.auth.IContext;
import com.v1ok.auth.IGenerator;
import com.v1ok.auth.IUserContext;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.time.DateUtils;

public class TokenGenerator
implements IGenerator {
    @Override
    public String token(IContext context, String securityKey) {
        return this.token(context, securityKey, DateUtils.addMinutes((Date)new Date(), (int)60));
    }

    @Override
    public String token(IContext context, String securityKey, Date expiration) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        byte[] apiKeySecretBytes = DigestUtils.md5((String)securityKey);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        if (context instanceof IAppContext) {
            IAppContext appContext = (IAppContext)context;
            JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").claim("appId", (Object)appContext.getAppId()).claim("securityKey", (Object)securityKey).signWith(signatureAlgorithm, (Key)signingKey).setExpiration(expiration);
            return builder.compact();
        }
        if (context instanceof IUserContext) {
            IUserContext userContext = (IUserContext)context;
            JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").claim("userId", (Object)userContext.getUserId()).claim("tenantId", (Object)userContext.getTenantId()).claim("positions", userContext.getPositions()).claim("permissions", userContext.getPermissions()).signWith(signatureAlgorithm, (Key)signingKey).setExpiration(expiration);
            return builder.compact();
        }
        return null;
    }
}

