/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.auth;

import com.v1ok.auth.AESUtil;
import com.v1ok.auth.IAppContext;
import com.v1ok.auth.IUserContext;
import com.v1ok.auth.impl.AppContextAccessTokenParse;
import com.v1ok.auth.impl.AppContextTokenParse;
import com.v1ok.auth.impl.UserContextAccessTokenParse;
import com.v1ok.auth.impl.UserContextTokenParse;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthVerify {
    private static final Logger log = LoggerFactory.getLogger(AuthVerify.class);

    public static boolean verifyToken(String token, String securityKey) {
        Validate.notBlank((CharSequence)token, (String)"The token string must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(DigestUtils.md5((String)securityKey)).parseClaimsJws(token).getBody();
            return claims != null;
        }
        catch (Exception exception) {
            log.warn("verify token is error", (Throwable)exception);
            return false;
        }
    }

    public static boolean verifyAccessToken(String accessToken, String securityKey) {
        Validate.notBlank((CharSequence)accessToken, (String)"The accessToken string must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        try {
            String decryptStr = AESUtil.decryptStr(accessToken, securityKey);
            Claims claims = (Claims)Jwts.parser().setSigningKey(DigestUtils.md5((String)securityKey)).parseClaimsJws(decryptStr).getBody();
            return claims != null;
        }
        catch (Exception exception) {
            log.warn("verify accessToken is error", (Throwable)exception);
            return false;
        }
    }

    public static IUserContext parseUserContextToken(String token, String securityKey) {
        Validate.notBlank((CharSequence)token, (String)"The token string must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        UserContextTokenParse tokenParse = new UserContextTokenParse();
        return tokenParse.parse(token, securityKey);
    }

    public static IUserContext parseUserContextAccessToken(String accessToken, String securityKey) {
        Validate.notBlank((CharSequence)accessToken, (String)"The token string must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        UserContextAccessTokenParse tokenParse = new UserContextAccessTokenParse();
        return tokenParse.parse(accessToken, securityKey);
    }

    public static IAppContext parseAppContextToken(String token, String securityKey) {
        Validate.notBlank((CharSequence)token, (String)"The token string must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        AppContextTokenParse tokenParse = new AppContextTokenParse();
        return tokenParse.parse(token, securityKey);
    }

    public static IAppContext parseAppContextAccessToken(String accessToken, String securityKey) {
        Validate.notBlank((CharSequence)accessToken, (String)"The token string must not be blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)securityKey, (String)"The securityKey must not be blank.", (Object[])new Object[0]);
        AppContextAccessTokenParse tokenParse = new AppContextAccessTokenParse();
        return tokenParse.parse(accessToken, securityKey);
    }
}

