/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.db.dao;

import com.google.common.collect.Lists;
import com.v1ok.db.dao.IDao;
import com.v1ok.db.model.ICreateByModel;
import com.v1ok.db.model.IEntityModel;
import com.v1ok.db.model.ISoftDeleteModel;
import com.v1ok.db.service.util.ExampleExpression;
import com.v1ok.db.support.Condition;
import com.v1ok.db.support.Group;
import com.v1ok.db.support.QueryBean;
import io.ebean.EbeanServer;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Junction;
import io.ebean.LikeType;
import io.ebean.PagedList;
import io.ebean.Query;
import io.ebean.UpdateQuery;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.expression.DefaultExampleExpression;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractDao<T extends IEntityModel, ID extends Serializable>
implements IDao<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDao.class);
    private Class<T> entityClass;
    @Autowired
    protected EbeanServer server;

    public AbstractDao() {
        Type genType = this.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.entityClass = (Class)params[0];
    }

    @Override
    public boolean exists(ID id) {
        Validate.notNull(id, (String)"The id must be not null !", (Object[])new Object[0]);
        return this.getQuery().setId(id).findCount() > 0;
    }

    @Override
    public boolean exists(T example) {
        Validate.notNull(example, (String)"The example entity must be not null !", (Object[])new Object[0]);
        DefaultExampleExpression defaultExampleExpression = new DefaultExampleExpression((EntityBean)example, false, LikeType.EQUAL_TO);
        return this.getQuery().where().add((Expression)defaultExampleExpression).findCount() > 0;
    }

    @Override
    public boolean exists(String propertyName, Object value) {
        Validate.notBlank((CharSequence)propertyName, (String)"The property name must be not blank !", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"The property value must be not null !", (Object[])new Object[0]);
        return this.getQuery().where().eq(propertyName, value).findCount() > 0;
    }

    @Override
    public Optional<T> findOne(ID id) {
        Validate.notNull(id, (String)"The id entity must be not null !", (Object[])new Object[0]);
        return this.getQuery().setId(id).findOneOrEmpty();
    }

    @Override
    public Optional<T> findOne(String propertyName, Object value) {
        Validate.notEmpty((CharSequence)propertyName, (String)"The name of property must be not empty !", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"The value of property must be not null !", (Object[])new Object[0]);
        return this.getQuery().where().eq(propertyName, value).findOneOrEmpty();
    }

    @Override
    public List<T> findAll() {
        return this.getQuery().findList();
    }

    @Override
    public List<T> findAll(T example) {
        DefaultExampleExpression defaultExampleExpression = new DefaultExampleExpression((EntityBean)example, false, LikeType.EQUAL_TO);
        return this.getQuery().where().add((Expression)defaultExampleExpression).findList();
    }

    @Override
    public List<T> findAll(String propertyName, Object value) {
        return this.getQuery().where().eq(propertyName, value).order().desc("createTime").findList();
    }

    @Override
    @SafeVarargs
    public final List<T> findAll(ID ... id) {
        return this.getQuery().where().idIn((Object[])id).findList();
    }

    @Override
    public Page<T> pageQuery(int pageNo, int pageSize) {
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        ExpressionList where = this.getQuery().where();
        return this.getPage(pageNo, pageSize, where);
    }

    @Override
    public Page<T> pageQuery(String propertyName, Object value, int pageNo, int pageSize) {
        Validate.notBlank((CharSequence)propertyName, (String)"The property name must be not blank !", (Object[])new Object[0]);
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        ExpressionList expressionList = this.getQuery().where().eq(propertyName, value).eq("deleted", (Object)false);
        return this.getPage(pageNo, pageSize, expressionList);
    }

    @Override
    public Page<T> pageQueryORExample(T example, int pageNo, int pageSize) {
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        Validate.notNull(example, (String)"The example entity must be not null !", (Object[])new Object[0]);
        ExpressionList where = this.getQuery().where();
        ExampleExpression.orExpression(where, example);
        return this.getPage(pageNo, pageSize, where);
    }

    @Override
    public Page<T> pageQueryANDExample(T example, int pageNo, int pageSize) {
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        Validate.notNull(example, (String)"The example entity must be not null !", (Object[])new Object[0]);
        ExpressionList where = this.getQuery().where();
        ExampleExpression.andExpression(where, example);
        return this.getPage(pageNo, pageSize, where);
    }

    @Override
    public Page<T> pageSearch(QueryBean queryBean) {
        Validate.notNull((Object)queryBean, (String)"The queryBean entity must be not null !", (Object[])new Object[0]);
        Validate.isTrue((queryBean.getPageNo() >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((queryBean.getPageSize() > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        ExpressionList<T> where = this.getExpressionList(queryBean);
        return this.getPage(queryBean.getPageNo(), queryBean.getPageSize(), where);
    }

    private ExpressionList<T> getExpressionList(QueryBean queryBean) {
        List groups = queryBean.getGroups();
        ExpressionList<T> where = this.getGroupWhere(queryBean.getOption(), groups);
        if (StringUtils.isNotEmpty((CharSequence)queryBean.getOrderBy())) {
            if (queryBean.isDesc()) {
                where.orderBy().desc(queryBean.getOrderBy());
            } else {
                where.orderBy(queryBean.getOrderBy());
            }
        }
        return where;
    }

    @Override
    public List<T> listSearch(QueryBean queryBean) {
        Validate.notNull((Object)queryBean, (String)"The queryBean entity must be not null !", (Object[])new Object[0]);
        ExpressionList<T> where = this.getExpressionList(queryBean);
        return where.findList();
    }

    @Override
    public T save(T entity) {
        this.server.save(entity);
        return entity;
    }

    @Override
    public Iterable<T> save(Iterable<T> iterable) {
        Validate.notNull(iterable, (String)"The iterable must be not null !", (Object[])new Object[0]);
        ArrayList beans = new ArrayList();
        CollectionUtils.addAll(beans, iterable.iterator());
        this.server.saveAll(beans);
        return beans;
    }

    @Override
    public List<T> save(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        this.server.saveAll(entities);
        return entities;
    }

    @Override
    public T update(T entity) {
        Validate.notNull(entity, (String)"The entity must be not null !", (Object[])new Object[0]);
        this.server.update(entity);
        return entity;
    }

    @Override
    public List<T> update(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        this.server.updateAll(entities);
        return entities;
    }

    @Override
    public boolean delete(T entity) {
        Validate.notNull(entity, (String)"The entity must be not null !", (Object[])new Object[0]);
        return this.server.delete(entity);
    }

    @Override
    public int delete(ID ... ids) {
        Validate.notNull(ids, (String)"The entity must be not null !", (Object[])new Object[0]);
        if (ISoftDeleteModel.class.isAssignableFrom(this.entityClass)) {
            return this.getServer().deleteAll(this.entityClass, Arrays.asList(ids));
        }
        throw new RuntimeException("The Entity class not support ISoftDeleteModel");
    }

    @Override
    public int delete(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        return this.server.deleteAll(entities);
    }

    @Override
    public int remove(String propertyName, Object propertyValue) {
        Validate.notEmpty((CharSequence)propertyName, (String)"The propertyName must be not empty !", (Object[])new Object[0]);
        Validate.notNull((Object)propertyValue, (String)"The propertyValue must be not empty !", (Object[])new Object[0]);
        return this.getQuery().where().eq(propertyName, propertyValue).delete();
    }

    @Override
    public int remove(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        return this.server.deleteAllPermanent(entities);
    }

    @Override
    public boolean remove(T entity) {
        Validate.notNull(entity, (String)"The entity must be not null !", (Object[])new Object[0]);
        return this.server.deletePermanent(entity);
    }

    @Override
    public int remove(ID id) {
        Validate.notNull(id, (String)"The id must be not null !", (Object[])new Object[0]);
        return this.server.deletePermanent(this.entityClass, id);
    }

    @Override
    public Query<T> getQuery() {
        return this.server.find(this.entityClass);
    }

    @Override
    public UpdateQuery<T> getUpdate() {
        return this.server.update(this.entityClass);
    }

    @Override
    public int delete(String propertyName, Object propertyValue) {
        if (ISoftDeleteModel.class.isAssignableFrom(this.entityClass)) {
            return this.getUpdate().set("deleted", (Object)true).where().eq(propertyName, propertyValue).update();
        }
        throw new RuntimeException("The Entity class not support ISoftDeleteModel");
    }

    @Override
    public Page<T> getPage(int pageNo, int pageSize, ExpressionList<T> where) {
        int count = where.findCount();
        if (count > 0) {
            if (ICreateByModel.class.isAssignableFrom(this.entityClass)) {
                PagedList pagedList = where.order().desc("createTime").setFirstRow(pageNo * pageSize).setMaxRows(pageSize).findPagedList();
                return this.convertPage(pageNo, pageSize, count, pagedList);
            }
            PagedList pagedList = where.setFirstRow(pageNo * pageSize).setMaxRows(pageSize).findPagedList();
            return this.convertPage(pageNo, pageSize, count, pagedList);
        }
        return this.convertPage(pageNo, pageSize, 0, null);
    }

    @Override
    public EbeanServer getServer() {
        return this.server;
    }

    protected PageImpl<T> convertPage(int pageNo, int pageSize, int totalCount, PagedList<T> pagedList) {
        if (pagedList != null) {
            return new PageImpl(pagedList.getList(), (Pageable)PageRequest.of((int)pageNo, (int)pageSize), (long)totalCount);
        }
        return new PageImpl((List)Lists.newArrayList(), (Pageable)PageRequest.of((int)pageNo, (int)pageSize), 0L);
    }

    private ExpressionList<T> getGroupWhere(String option, List<Group> groups) {
        ExpressionList where = this.getQuery().where();
        Junction junction = "or".equalsIgnoreCase(option) ? where.or() : where.and();
        for (Group group : groups) {
            ExpressionList<T> conditionWhere = this.getConditionWhere(group.getConditions());
            if (conditionWhere == null) continue;
            if ("or".equalsIgnoreCase(group.getOption())) {
                junction.or().addAll(conditionWhere).endOr();
                continue;
            }
            junction.and().addAll(conditionWhere).endAnd();
        }
        if ("or".equalsIgnoreCase(option)) {
            junction.endOr();
        } else {
            junction.endAnd();
        }
        return where;
    }

    private ExpressionList<T> getConditionWhere(List<Condition> conditions) {
        ExpressionList where = null;
        block48: for (Condition condition : conditions) {
            String column = condition.getColumn();
            if (StringUtils.isEmpty((CharSequence)column) || StringUtils.isEmpty((CharSequence)condition.getOption())) continue;
            Object value = condition.getValue();
            if (value instanceof String && !condition.getOption().contains("null")) {
                String strValue = (String)value;
                strValue = strValue.replaceAll("%", "");
                if (StringUtils.isEmpty((CharSequence)column) || StringUtils.isEmpty((CharSequence)strValue)) continue;
            }
            if (value instanceof List && value == null || "between".equalsIgnoreCase(condition.getOption()) && (condition.getStart() == null || condition.getEnd() == null)) continue;
            Map<String, String> path = this.processJsonPath(column);
            if (value == null && !"between".equalsIgnoreCase(condition.getOption())) continue;
            if (where == null) {
                where = this.getQuery().where();
            }
            switch (StringUtils.lowerCase((String)condition.getOption())) {
                case "eq": {
                    where.eq(column, value);
                    continue block48;
                }
                case "like": {
                    where.like(column, (String)value);
                    continue block48;
                }
                case "in": {
                    where.in(column, new Object[]{value});
                    continue block48;
                }
                case "not_in": {
                    where.notIn(column, new Object[]{value});
                    continue block48;
                }
                case "is_null": {
                    where.isNull(column);
                    continue block48;
                }
                case "is_not_null": {
                    where.isNotNull(column);
                    continue block48;
                }
                case "le": {
                    where.le(column, value);
                    continue block48;
                }
                case "lt": {
                    where.le(column, value);
                    continue block48;
                }
                case "ge": {
                    where.ge(column, value);
                    continue block48;
                }
                case "gt": {
                    where.gt(column, value);
                    continue block48;
                }
                case "between": {
                    where.between(column, (Object)condition.getStart(), condition.getEnd());
                    continue block48;
                }
                case "array_in": {
                    where.arrayContains(column, ((List)value).toArray());
                    continue block48;
                }
                case "array_not_in": {
                    where.arrayNotContains(column, ((List)value).toArray());
                    continue block48;
                }
                case "array_is_null": {
                    where.arrayIsEmpty(column);
                    continue block48;
                }
                case "array_is_not_null": {
                    where.arrayIsNotEmpty(column);
                    continue block48;
                }
                case "json_b_eq": {
                    where.jsonEqualTo(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_not_eq": {
                    where.jsonNotEqualTo(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_ge": {
                    where.jsonGreaterOrEqual(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_gt": {
                    where.jsonGreaterThan(path.get("column"), path.get("path"), condition.getValue());
                }
                case "json_b_le": {
                    where.jsonLessOrEqualTo(path.get("column"), path.get("path"), condition.getValue());
                }
                case "json_b_lt": {
                    where.jsonLessThan(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_between": {
                    where.jsonBetween(path.get("column"), path.get("path"), (Object)condition.getStart(), condition.getEnd());
                    continue block48;
                }
            }
            where.eq(condition.getColumn(), condition.getValue());
        }
        return where;
    }

    private Map<String, String> processJsonPath(String column) {
        int firstPointIndex = column.indexOf(".");
        if (firstPointIndex == -1) {
            return null;
        }
        String jsonColumn = column.substring(0, firstPointIndex);
        String path = column.substring(firstPointIndex + 1);
        if (StringUtils.isEmpty((CharSequence)jsonColumn) || StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("column", jsonColumn);
        result.put("path", path);
        return result;
    }
}

