/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.db.service;

import com.v1ok.db.dao.IDao;
import com.v1ok.db.model.IEntityModel;
import com.v1ok.db.service.IService;
import com.v1ok.db.support.QueryBean;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractService<T extends IEntityModel, ID extends Serializable>
implements IService<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(AbstractService.class);
    @Autowired
    protected IDao<T, ID> dao;

    public boolean exists(ID id) {
        return this.dao.exists(id);
    }

    public boolean exists(T example) {
        return this.dao.exists(example);
    }

    public boolean exists(String propertyName, Object value) {
        return this.dao.exists(propertyName, value);
    }

    public Optional<T> findOne(ID id) {
        return this.dao.findOne(id);
    }

    public Optional<T> findOne(String propertyName, Object value) {
        return this.dao.findOne(propertyName, value);
    }

    public List<T> findAll() {
        return this.dao.findAll();
    }

    public List<T> findAll(T example) {
        return this.dao.findAll(example);
    }

    public List<T> findAll(ID ... id) {
        return this.dao.findAll(id);
    }

    public List<T> findAll(String propertyName, Object value) {
        return this.dao.findAll(propertyName, value);
    }

    public Page<T> pageQuery(int pageNo, int pageSize) {
        return this.dao.pageQuery(pageNo, pageSize);
    }

    public Page<T> pageQuery(String propertyName, Object value, int pageNo, int pageSize) {
        return this.dao.pageQuery(propertyName, value, pageNo, pageSize);
    }

    public Page<T> pageQueryORExample(T example, int pageNo, int pageSize) {
        return this.dao.pageQueryORExample(example, pageNo, pageSize);
    }

    public Page<T> pageQueryANDExample(T example, int pageNo, int pageSize) {
        return this.dao.pageQueryANDExample(example, pageNo, pageSize);
    }

    public Page<T> pageSearch(QueryBean queryBean) {
        return this.dao.pageSearch(queryBean);
    }

    public List<T> listSearch(QueryBean queryBean) {
        return this.dao.listSearch(queryBean);
    }

    public T save(T entity) {
        return this.dao.save(entity);
    }

    public Iterable<T> save(Iterable<T> iterable) {
        return this.dao.save(iterable);
    }

    public List<T> save(List<T> entities) {
        return this.dao.save(entities);
    }

    public T update(T entity) {
        return this.dao.update(entity);
    }

    public List<T> update(List<T> entities) {
        return this.dao.update(entities);
    }

    public boolean delete(T entity) {
        return this.dao.delete(entity);
    }

    public int delete(ID ... id) {
        return this.dao.delete((Serializable[])id);
    }

    public int delete(List<T> entities) {
        return this.dao.delete(entities);
    }

    public int delete(String propertyName, Object propertyValue) {
        return this.dao.delete(propertyName, propertyValue);
    }

    public int remove(String propertyName, Object propertyValue) {
        return this.dao.remove(propertyName, propertyValue);
    }

    public int remove(List<T> entities) {
        return this.dao.remove(entities);
    }

    public boolean remove(T entity) {
        return this.dao.remove(entity);
    }

    public int remove(ID id) {
        return this.dao.remove(id);
    }
}

