/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.db.util;

import java.io.IOException;
import java.security.SecureRandom;

public class IDGenerator {
    private static final CustomUUID uuid = new CustomUUID(3L, 0L);

    public static Long generate() {
        return uuid.generate();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(IDGenerator.generate());
        }
        try {
            Process process = new ProcessBuilder("").start();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class CustomUUID {
        private long twepoch = 1288834974657L;
        private static final long regionIdBits = 3L;
        private static final long workerIdBits = 2L;
        private static final long sequenceBits = 10L;
        private static final long maxRegionId = 7L;
        private static final long maxWorkerId = 3L;
        private static final long sequenceMask = 1023L;
        private static final long workerIdShift = 10L;
        private static final long regionIdShift = 12L;
        private static final long timestampLeftShift = 15L;
        private static long lastTimestamp = -1L;
        private long sequence = 0L;
        private final long workerId;
        private final long regionId;

        public CustomUUID(long workerId, long regionId) {
            if (workerId > 3L || workerId < 0L) {
                throw new IllegalArgumentException("worker Id can't be greater than %d or less than 0");
            }
            if (regionId > 7L || regionId < 0L) {
                throw new IllegalArgumentException("datacenter Id can't be greater than %d or less than 0");
            }
            this.workerId = workerId;
            this.regionId = regionId;
        }

        public CustomUUID(long workerId) {
            if (workerId > 3L || workerId < 0L) {
                throw new IllegalArgumentException("worker Id can't be greater than %d or less than 0");
            }
            this.workerId = workerId;
            this.regionId = 0L;
        }

        public long generate() {
            return this.nextId(false, 0L);
        }

        private synchronized long nextId(boolean isPadding, long busId) {
            long timestamp = this.timeGen();
            long paddingnum = this.regionId;
            if (isPadding) {
                paddingnum = busId;
            }
            if (timestamp < lastTimestamp) {
                try {
                    throw new Exception("Clock moved backwards.  Refusing to generate id for " + (lastTimestamp - timestamp) + " milliseconds");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0x3FFL;
                if (this.sequence == 0L) {
                    timestamp = this.tailNextMillis(lastTimestamp);
                }
            } else {
                this.sequence = new SecureRandom().nextInt(10);
            }
            lastTimestamp = timestamp;
            return timestamp - this.twepoch << 15 | paddingnum << 12 | this.workerId << 10 | this.sequence;
        }

        private long tailNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }
    }
}

