/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.db.service;

import com.google.common.collect.Lists;
import com.v1ok.db.service.IEntityModel;
import com.v1ok.db.service.IService;
import com.v1ok.db.service.util.ExampleExpression;
import com.v1ok.db.support.Condition;
import com.v1ok.db.support.Group;
import com.v1ok.db.support.QueryBean;
import io.ebean.EbeanServer;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Junction;
import io.ebean.LikeType;
import io.ebean.PagedList;
import io.ebean.Query;
import io.ebean.UpdateQuery;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.expression.DefaultExampleExpression;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractService<T extends IEntityModel, ID extends Serializable>
implements IService<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(AbstractService.class);
    private Class<T> entityClass;
    @Autowired
    protected EbeanServer server;

    public AbstractService() {
        Type genType = this.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.entityClass = (Class)params[0];
    }

    public boolean exists(ID id) {
        Validate.notNull(id, (String)"The id must be not null !", (Object[])new Object[0]);
        return this.getQuery().setId(id).findCount() > 0;
    }

    public boolean exists(T example) {
        Validate.notNull(example, (String)"The example entity must be not null !", (Object[])new Object[0]);
        DefaultExampleExpression defaultExampleExpression = new DefaultExampleExpression((EntityBean)example, false, LikeType.EQUAL_TO);
        return this.getQuery().where().add((Expression)defaultExampleExpression).findCount() > 0;
    }

    public boolean exists(String propertyName, Object value) {
        Validate.notBlank((CharSequence)propertyName, (String)"The property name must be not blank !", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"The property value must be not null !", (Object[])new Object[0]);
        return this.getQuery().where().eq(propertyName, value).findCount() > 0;
    }

    public Optional<T> findOne(ID id) {
        Validate.notNull(id, (String)"The id entity must be not null !", (Object[])new Object[0]);
        return this.getQuery().setId(id).findOneOrEmpty();
    }

    public Optional<T> findOne(String propertyName, Object value) {
        Validate.notEmpty((CharSequence)propertyName, (String)"The name of property must be not empty !", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"The value of property must be not null !", (Object[])new Object[0]);
        return this.getQuery().where().eq(propertyName, value).findOneOrEmpty();
    }

    public List<T> findAll() {
        return this.getQuery().findList();
    }

    public List<T> findAll(T example) {
        DefaultExampleExpression defaultExampleExpression = new DefaultExampleExpression((EntityBean)example, false, LikeType.EQUAL_TO);
        return this.getQuery().where().add((Expression)defaultExampleExpression).findList();
    }

    public List<T> findAll(String propertyName, Object value) {
        return this.getQuery().where().eq(propertyName, value).order().desc("createTime").findList();
    }

    public Page<T> pageQuery(int pageNo, int pageSize) {
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        Query<T> query = this.getQuery();
        int count = query.where().findCount();
        if (count > 0) {
            PagedList pagedList = query.where().order().desc("pid").setFirstRow(pageNo * pageSize).setMaxRows(pageSize).findPagedList();
            return this.convertPage(pageNo, pageSize, count, pagedList);
        }
        return this.convertPage(pageNo, pageSize, 0, null);
    }

    public Page<T> pageQuery(T example, int pageNo, int pageSize) {
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        Validate.notNull(example, (String)"The example entity must be not null !", (Object[])new Object[0]);
        ExpressionList where = this.getQuery().where();
        ExampleExpression.andExpression(where, example);
        int count = where.findCount();
        if (count > 0) {
            PagedList pagedList = where.order().desc("pid").setFirstRow(pageNo * pageSize).setMaxRows(pageSize).findPagedList();
            return this.convertPage(pageNo, pageSize, count, pagedList);
        }
        return this.convertPage(pageNo, pageSize, 0, null);
    }

    public Page<T> pageQuery(String propertyName, Object value, int pageNo, int pageSize) {
        Validate.notBlank((CharSequence)propertyName, (String)"The property name must be not blank !", (Object[])new Object[0]);
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        ExpressionList expressionList = this.getQuery().where().eq(propertyName, value).eq("deleted", (Object)false);
        int count = expressionList.findCount();
        if (count > 0) {
            PagedList pagedList = expressionList.setFirstRow(pageNo * pageSize).setMaxRows(pageSize).findPagedList();
            return this.convertPage(pageNo, pageSize, count, pagedList);
        }
        return this.convertPage(pageNo, pageSize, 0, null);
    }

    public Page<T> pageSearch(T example, int pageNo, int pageSize) {
        Validate.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        Validate.notNull(example, (String)"The example entity must be not null !", (Object[])new Object[0]);
        ExpressionList where = this.getQuery().where();
        ExampleExpression.orExpression(where, example);
        int count = where.findCount();
        if (count > 0) {
            PagedList pagedList = where.order().desc("pid").setFirstRow(pageNo * pageSize).setMaxRows(pageSize).findPagedList();
            return this.convertPage(pageNo, pageSize, count, pagedList);
        }
        return this.convertPage(pageNo, pageSize, 0, null);
    }

    public Page<T> pageSearch(QueryBean queryBean) {
        int count;
        Validate.notNull((Object)queryBean, (String)"The queryBean entity must be not null !", (Object[])new Object[0]);
        Validate.isTrue((queryBean.getPageNo() >= 0 ? 1 : 0) != 0, (String)"The pageNo must be greater than or equal to zero !", (Object[])new Object[0]);
        Validate.isTrue((queryBean.getPageSize() > 0 ? 1 : 0) != 0, (String)"The pageSize must be greater than zero !", (Object[])new Object[0]);
        List groups = queryBean.getGroups();
        ExpressionList<T> where = this.getGroupWhere(queryBean.getOption(), groups);
        if (StringUtils.isNotEmpty((CharSequence)queryBean.getOrderBy())) {
            if (queryBean.isDesc()) {
                where.orderBy().desc(queryBean.getOrderBy());
            } else {
                where.orderBy(queryBean.getOrderBy());
            }
        }
        if ((count = where.findCount()) > 0) {
            PagedList pagedList = where.order().desc("pid").setFirstRow(queryBean.getPageNo() * queryBean.getPageSize()).setMaxRows(queryBean.getPageSize()).findPagedList();
            return this.convertPage(queryBean.getPageNo(), queryBean.getPageSize(), count, pagedList);
        }
        return this.convertPage(queryBean.getPageNo(), queryBean.getPageSize(), 0, null);
    }

    public List<T> listSearch(QueryBean queryBean) {
        Validate.notNull((Object)queryBean, (String)"The queryBean entity must be not null !", (Object[])new Object[0]);
        List groups = queryBean.getGroups();
        ExpressionList<T> where = this.getGroupWhere(queryBean.getOption(), groups);
        if (StringUtils.isNotEmpty((CharSequence)queryBean.getOrderBy())) {
            if (queryBean.isDesc()) {
                where.orderBy().desc(queryBean.getOrderBy());
            } else {
                where.orderBy(queryBean.getOrderBy());
            }
        }
        return where.findList();
    }

    private ExpressionList<T> getGroupWhere(String option, List<Group> groups) {
        ExpressionList where = this.getQuery().where();
        Junction junction = "or".equalsIgnoreCase(option) ? where.or() : where.and();
        for (Group group : groups) {
            ExpressionList<T> conditionWhere = this.getConditionWhere(group.getConditions());
            if (conditionWhere == null) continue;
            if ("or".equalsIgnoreCase(group.getOption())) {
                junction.or().addAll(conditionWhere).endOr();
                continue;
            }
            junction.and().addAll(conditionWhere).endAnd();
        }
        if ("or".equalsIgnoreCase(option)) {
            junction.endOr();
        } else {
            junction.endAnd();
        }
        return where;
    }

    private ExpressionList<T> getConditionWhere(List<Condition> conditions) {
        ExpressionList where = null;
        block48: for (Condition condition : conditions) {
            String column = condition.getColumn();
            if (StringUtils.isEmpty((CharSequence)column) || StringUtils.isEmpty((CharSequence)condition.getOption())) continue;
            Object value = condition.getValue();
            if (value instanceof String && !condition.getOption().contains("null")) {
                String strValue = (String)value;
                strValue = strValue.replaceAll("%", "");
                if (StringUtils.isEmpty((CharSequence)column) || StringUtils.isEmpty((CharSequence)strValue)) continue;
            }
            if (value instanceof List && value == null || "between".equalsIgnoreCase(condition.getOption()) && (condition.getStart() == null || condition.getEnd() == null)) continue;
            Map<String, String> path = this.processJsonPath(column);
            if (value == null && !"between".equalsIgnoreCase(condition.getOption())) continue;
            if (where == null) {
                where = this.getQuery().where();
            }
            switch (StringUtils.lowerCase((String)condition.getOption())) {
                case "eq": {
                    where.eq(column, value);
                    continue block48;
                }
                case "like": {
                    where.like(column, (String)value);
                    continue block48;
                }
                case "in": {
                    where.in(column, new Object[]{value});
                    continue block48;
                }
                case "not_in": {
                    where.notIn(column, new Object[]{value});
                    continue block48;
                }
                case "is_null": {
                    where.isNull(column);
                    continue block48;
                }
                case "is_not_null": {
                    where.isNotNull(column);
                    continue block48;
                }
                case "le": {
                    where.le(column, value);
                    continue block48;
                }
                case "lt": {
                    where.le(column, value);
                    continue block48;
                }
                case "ge": {
                    where.ge(column, value);
                    continue block48;
                }
                case "gt": {
                    where.gt(column, value);
                    continue block48;
                }
                case "between": {
                    where.between(column, (Object)condition.getStart(), condition.getEnd());
                    continue block48;
                }
                case "array_in": {
                    where.arrayContains(column, ((List)value).toArray());
                    continue block48;
                }
                case "array_not_in": {
                    where.arrayNotContains(column, ((List)value).toArray());
                    continue block48;
                }
                case "array_is_null": {
                    where.arrayIsEmpty(column);
                    continue block48;
                }
                case "array_is_not_null": {
                    where.arrayIsNotEmpty(column);
                    continue block48;
                }
                case "json_b_eq": {
                    where.jsonEqualTo(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_not_eq": {
                    where.jsonNotEqualTo(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_ge": {
                    where.jsonGreaterOrEqual(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_gt": {
                    where.jsonGreaterThan(path.get("column"), path.get("path"), condition.getValue());
                }
                case "json_b_le": {
                    where.jsonLessOrEqualTo(path.get("column"), path.get("path"), condition.getValue());
                }
                case "json_b_lt": {
                    where.jsonLessThan(path.get("column"), path.get("path"), condition.getValue());
                    continue block48;
                }
                case "json_b_between": {
                    where.jsonBetween(path.get("column"), path.get("path"), (Object)condition.getStart(), condition.getEnd());
                    continue block48;
                }
            }
            where.eq(condition.getColumn(), condition.getValue());
        }
        return where;
    }

    private Map<String, String> processJsonPath(String column) {
        int firstPointIndex = column.indexOf(".");
        if (firstPointIndex == -1) {
            return null;
        }
        String jsonColumn = column.substring(0, firstPointIndex);
        String path = column.substring(firstPointIndex + 1);
        if (StringUtils.isEmpty((CharSequence)jsonColumn) || StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("column", jsonColumn);
        result.put("path", path);
        return result;
    }

    public T save(T entity) {
        this.server.save(entity);
        return entity;
    }

    public Iterable<T> save(Iterable<T> iterable) {
        Validate.notNull(iterable, (String)"The iterable must be not null !", (Object[])new Object[0]);
        ArrayList beans = new ArrayList();
        CollectionUtils.addAll(beans, iterable.iterator());
        this.server.saveAll(beans);
        return beans;
    }

    public List<T> save(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        this.server.saveAll(entities);
        return entities;
    }

    public T update(T entity) {
        Validate.notNull(entity, (String)"The entity must be not null !", (Object[])new Object[0]);
        this.server.update(entity);
        return entity;
    }

    public List<T> update(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        this.server.updateAll(entities);
        return entities;
    }

    public boolean delete(T entity) {
        Validate.notNull(entity, (String)"The entity must be not null !", (Object[])new Object[0]);
        return this.server.delete(entity);
    }

    public int delete(ID ... id) {
        Validate.notNull(id, (String)"The entity must be not null !", (Object[])new Object[0]);
        return this.server.update(this.entityClass).set("deleted", (Object)true).where().in("pid", (Object[])id).update();
    }

    public int delete(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        return this.server.deleteAll(entities);
    }

    public int remove(String propertyName, Object propertyValue) {
        Validate.notEmpty((CharSequence)propertyName, (String)"The propertyName must be not empty !", (Object[])new Object[0]);
        Validate.notNull((Object)propertyValue, (String)"The propertyValue must be not empty !", (Object[])new Object[0]);
        return this.getQuery().where().eq(propertyName, propertyValue).delete();
    }

    public int remove(List<T> entities) {
        Validate.notEmpty(entities, (String)"The entities must be not empty !", (Object[])new Object[0]);
        return this.server.deleteAllPermanent(entities);
    }

    public boolean remove(T entity) {
        Validate.notNull(entity, (String)"The entity must be not null !", (Object[])new Object[0]);
        return this.server.deletePermanent(entity);
    }

    public int remove(ID id) {
        Validate.notNull(id, (String)"The id must be not null !", (Object[])new Object[0]);
        return this.server.deletePermanent(this.entityClass, id);
    }

    protected Query<T> getQuery() {
        return this.server.find(this.entityClass);
    }

    protected UpdateQuery<T> getUpdate() {
        return this.server.update(this.entityClass);
    }

    protected PageImpl<T> convertPage(int pageNo, int pageSize, int totalCount, PagedList<T> pagedList) {
        if (pagedList != null) {
            return new PageImpl(pagedList.getList(), (Pageable)PageRequest.of((int)pageNo, (int)pageSize), (long)totalCount);
        }
        return new PageImpl((List)Lists.newArrayList(), (Pageable)PageRequest.of((int)pageNo, (int)pageSize), 0L);
    }

    public List<T> findAll(ID ... id) {
        throw new UnsupportedOperationException();
    }

    public int delete(String propertyName, Object propertyValue) {
        throw new UnsupportedOperationException();
    }
}

