/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok;

import com.v1ok.db.util.ModUUIDGenerator;
import io.ebean.config.CurrentUserProvider;
import io.ebean.config.ExternalTransactionManager;
import io.ebean.config.IdGenerator;
import io.ebean.config.ServerConfig;
import io.ebean.spring.txn.SpringJdbcTransactionManager;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.v1ok.db"})
public class AutoConfig
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Bean
    public ServerConfig serverConfig(@Autowired(required=false) DataSource dataSource, @Autowired ModUUIDGenerator uuidGenerator, @Autowired CurrentUserProvider currentUser) {
        ServerConfig config = new ServerConfig();
        config.setName("db");
        config.setCurrentUserProvider(currentUser);
        config.setDataSource(dataSource);
        config.setExternalTransactionManager((ExternalTransactionManager)new SpringJdbcTransactionManager());
        config.loadFromProperties();
        config.add((IdGenerator)uuidGenerator);
        config.setDefaultServer(true);
        config.setRegister(true);
        return config;
    }

    @Bean
    public ModUUIDGenerator modUUIDGenerator() {
        return new ModUUIDGenerator();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

