/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.web3j;

import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ups.PlainServiceInfo;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

public class Web3jFactoryBean
extends AbstractFactoryBean<Web3j> {
    private static final Logger log = LoggerFactory.getLogger(Web3jFactoryBean.class);
    private final ApplicationProperties props;
    private final PlainServiceInfo serviceInfo;

    public Class<?> getObjectType() {
        return Web3j.class;
    }

    protected Web3j createInstance() throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((Duration)this.props.TCP_CONNECTION_TIMEOUT.get());
        builder.readTimeout((Duration)this.props.TCP_SOCKET_TIMEOUT.get());
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)log).debug(arg_0));
        logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        builder.addInterceptor((Interceptor)logging);
        OkHttpClient okhttp = builder.build();
        String uri = this.serviceInfo.getUri();
        HttpService httpService = new HttpService(uri, okhttp, false);
        return Web3j.build((Web3jService)httpService);
    }

    protected void destroyInstance(Web3j instance) throws Exception {
        if (instance != null) {
            instance.shutdown();
        }
    }

    public Web3jFactoryBean(ApplicationProperties props, PlainServiceInfo serviceInfo) {
        this.props = props;
        this.serviceInfo = serviceInfo;
    }
}

