/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.web3j;

import com.google.common.net.HostAndPort;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.common.SSL;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.UPSs;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

public class Web3jFactoryBean
extends AbstractFactoryBean<Web3j>
implements BootstrapAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PlainServiceInfo serviceInfo;
    private Bootstrap bootstrap;

    public Web3jFactoryBean() {
    }

    public Web3jFactoryBean(PlainServiceInfo serviceInfo) throws Exception {
        this.serviceInfo = Objects.requireNonNull(serviceInfo);
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        if (this.serviceInfo == null) {
            this.serviceInfo = (PlainServiceInfo)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"web3j");
        }
    }

    public Class<?> getObjectType() {
        return Web3j.class;
    }

    protected Web3j createInstance() throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)((Integer)this.bootstrap.props().TCP_CONNECTION_TIMEOUT.get()).intValue(), TimeUnit.SECONDS);
        builder.readTimeout((long)((Integer)this.bootstrap.props().TCP_SOCKET_TIMEOUT.get()).intValue(), TimeUnit.SECONDS);
        if (this.bootstrap.isDevMode() && "https".equalsIgnoreCase(this.serviceInfo.getScheme())) {
            SSL ssl = new SSL();
            ssl.addUntrustedCertificates(new HostAndPort[]{HostAndPort.fromHost((String)this.serviceInfo.getHost())});
            Map.Entry entry = ssl.buildSSLFactory();
            builder.sslSocketFactory((SSLSocketFactory)entry.getKey(), (X509TrustManager)entry.getValue());
        }
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)this.log).debug(arg_0));
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        builder.addInterceptor((Interceptor)logging);
        OkHttpClient okhttp = builder.build();
        String uri = this.serviceInfo.getUri();
        HttpService httpService = new HttpService(uri, okhttp, false);
        return Web3j.build((Web3jService)httpService);
    }

    protected void destroyInstance(Web3j instance) throws Exception {
        if (instance != null) {
            instance.shutdown();
        }
    }
}

