package com.turbospaces.web3j;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.http.HttpService;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.ups.PlainServiceInfo;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class Web3jFactoryBean extends AbstractFactoryBean<Web3j> implements BootstrapAware {
    private final Logger log = LoggerFactory.getLogger(getClass());
    private final PlainServiceInfo serviceInfo;
    private Bootstrap bootstrap;

    public Web3jFactoryBean(PlainServiceInfo serviceInfo) throws Exception {
        this.serviceInfo = Objects.requireNonNull(serviceInfo);
    }
    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
    @Override
    public Class<?> getObjectType() {
        return Web3j.class;
    }
    @Override
    protected Web3j createInstance() throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(bootstrap.props().TCP_CONNECTION_TIMEOUT.get());
        builder.readTimeout(bootstrap.props().TCP_SOCKET_TIMEOUT.get());

        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(log::debug);
        logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        builder.addInterceptor(logging);

        OkHttpClient okhttp = builder.build();

        String uri = serviceInfo.getUri();
        HttpService httpService = new HttpService(uri, okhttp, false);
        return Web3j.build(httpService);
    }
    @Override
    protected void destroyInstance(Web3j instance) throws Exception {
        if (instance != null) {
            instance.shutdown();
        }
    }
}
