/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.NetVersion;

public class Web3jHealthCheck
extends HealthCheck {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Web3j web3j;

    public Web3jHealthCheck(Web3j web3j) {
        this.web3j = Objects.requireNonNull(web3j);
    }

    protected HealthCheck.Result check() throws Exception {
        try {
            String version = ((NetVersion)this.web3j.netVersion().send()).getNetVersion();
            return HealthCheck.Result.healthy((String)("net version: " + version));
        }
        catch (Exception err) {
            this.logger.warn(err.getMessage(), (Throwable)err);
            return HealthCheck.Result.unhealthy((Throwable)err);
        }
    }
}

