package com.turbospaces.healthchecks;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;

import com.codahale.metrics.health.HealthCheck;

public class Web3jHealthCheck extends HealthCheck {
    private Logger logger = LoggerFactory.getLogger( getClass() );
    private Web3j web3j;

    public Web3jHealthCheck(Web3j web3j) {
        this.web3j = Objects.requireNonNull( web3j );
    }
    @Override
    protected Result check() throws Exception {
        try {
            String version = web3j.netVersion().send().getNetVersion();
            return Result.healthy( "net version: " + version );
        }
        catch ( Exception err ) {
            logger.warn( err.getMessage(), err );
            return HealthCheck.Result.unhealthy( err );
        }
    }
}
