/*
 * Decompiled with CFR 0.152.
 */
package com.turbopsaces.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Checksum {
    public static String chk(ObjectMapper mapper, String json) throws IOException {
        StringBuilder builder = new StringBuilder();
        Checksum.chk(builder, mapper.readTree(json), false);
        return builder.toString();
    }

    public static String chk(JsonNode node) {
        StringBuilder builder = new StringBuilder();
        Checksum.chk(builder, node, false);
        return builder.toString();
    }

    private static void chk(StringBuilder str, JsonNode currentNode, boolean debug) {
        if (!currentNode.isNull()) {
            if (currentNode.isArray()) {
                ArrayNode array = (ArrayNode)currentNode;
                Iterator it = array.elements();
                if (debug) {
                    str.append("[");
                }
                int i = 0;
                while (it.hasNext()) {
                    str.append(i).append("=");
                    Checksum.chk(str, (JsonNode)it.next(), debug);
                    if (it.hasNext()) {
                        str.append("&");
                    }
                    ++i;
                }
                if (debug) {
                    str.append("]");
                }
            } else if (currentNode.isObject()) {
                TreeMap m = Maps.newTreeMap();
                Iterator names = currentNode.fieldNames();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    JsonNode value = currentNode.get(name);
                    m.put(name, value);
                }
                if (debug) {
                    str.append("{");
                }
                Iterator it = m.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String name = (String)entry.getKey();
                    str.append(name).append("=");
                    Checksum.chk(str, (JsonNode)entry.getValue(), debug);
                    if (!it.hasNext()) continue;
                    str.append("&");
                }
                if (debug) {
                    str.append("}");
                }
            } else if (currentNode.isTextual()) {
                str.append(currentNode.asText());
            } else {
                str.append(currentNode.toString());
            }
        }
    }
}

