/*
 * Decompiled with CFR 0.152.
 */
package com.turbopsaces.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.metadata.BeanDescriptor;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class POJOValidator
implements Validator {
    private final Validator validator;

    public POJOValidator() {
        HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        try (ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)config.ignoreXmlConfiguration()).buildValidatorFactory();){
            this.validator = validatorFactory.getValidator();
        }
    }

    public POJOValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public Set<ConstraintViolation<Object>> validate(Object obj) throws IllegalArgumentException {
        return this.validator.validate(obj, new Class[0]);
    }

    public Set<String> validateWithFormattedOutput(Object obj) {
        return this.validate(obj).stream().map(POJOValidator::formatViolation).collect(Collectors.toSet());
    }

    public boolean isValid(Object obj) {
        return this.validate(obj).isEmpty();
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.validator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.validator.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.validator.unwrap(type);
    }

    public ExecutableValidator forExecutables() {
        return this.validator.forExecutables();
    }

    public static String formatViolation(final ConstraintViolation<?> constraintViolation) {
        String beanName = constraintViolation.getRootBeanClass().getSimpleName();
        Iterable<Path.Node> iterable = new Iterable<Path.Node>(){

            @Override
            public Iterator<Path.Node> iterator() {
                return constraintViolation.getPropertyPath().iterator();
            }
        };
        String path = StreamSupport.stream(iterable.spliterator(), false).map(Path.Node::getName).collect(Collectors.joining("."));
        return String.format("%s.%s = invalid value(%s)", beanName, path, String.valueOf(constraintViolation.getInvalidValue()));
    }
}

