/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.validation;

import com.turbopsaces.validation.POJOValidator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class POJOValidatorTest {
    @Test
    public void works() {
        POJOValidator validator = new POJOValidator();
        Bean bean = new Bean();
        bean.v1 = String.valueOf(System.currentTimeMillis());
        bean.v2 = System.currentTimeMillis();
        SpringValidatorAdapter adapter = new SpringValidatorAdapter((Validator)validator);
        Set violations = adapter.validate((Object)bean, new Class[0]);
        Assertions.assertEquals((int)1, (int)violations.size());
        for (ConstraintViolation constraintViolation : violations) {
            System.out.println(POJOValidator.formatViolation((ConstraintViolation)constraintViolation));
        }
    }

    public static class Bean {
        @NotEmpty
        public String v1;
        @Min(value=1L)
        @Max(value=10L)
        public @Min(value=1L) @Max(value=10L) long v2;
    }
}

