/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.infinispan;

import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.jgroups.JGroupsFactoryBean;
import org.jgroups.JChannel;
import org.jgroups.blocks.ReplicatedHashMap;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class JgroupsPluginTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg.factory()), new Class[]{AppConfig.class});
        ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
        try {
            JChannel channel = (JChannel)applicationContext.getBean(JChannel.class);
            try (ReplicatedHashMap cache = new ReplicatedHashMap(channel);){
                channel.connect(this.getClass().getSimpleName());
                cache.start(300000L);
                cache.put((Object)"1", (Object)1);
                cache.put((Object)"2", (Object)2);
                cache.clear();
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Configuration
    public static class AppConfig {
        @Bean
        public JGroupsFactoryBean jgroups(ApplicationProperties props) {
            return new JGroupsFactoryBean(props);
        }
    }
}

