/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.stack.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeADNSResolver
implements DNSResolver {
    private static final Logger log = LoggerFactory.getLogger(TypeADNSResolver.class);
    public static final int DEFAULT_COMMUNICATION_PORT = 6800;

    public List<Address> resolveIps(String dnsQuery, DNSResolver.DNSRecordType recordType) {
        String bindPort = System.getProperty("jgroups.bind_port", Integer.toString(6800));
        ImmutableList.Builder addresses = ImmutableList.builder();
        try {
            Object[] inetAddresses;
            for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(dnsQuery)) {
                addresses.add((Object)new IpAddress(inetAddress.getHostAddress(), Integer.parseInt(bindPort)));
            }
            log.debug("DNS lookup: {}", (Object)Arrays.toString(inetAddresses));
        }
        catch (UnknownHostException ex) {
            log.atWarn().setMessage("failed to resolve DNS query: " + dnsQuery).setCause((Throwable)ex).log();
        }
        return addresses.build();
    }
}

