package org.jgroups.protocols.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeADNSResolver implements DNSResolver {
    public static final int DEFAULT_COMMUNICATION_PORT = 6800;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public List<Address> resolveIps(String dnsQuery, DNSRecordType recordType) {
        String bindPort = System.getProperty("jgroups.bind_port", Integer.toString(DEFAULT_COMMUNICATION_PORT));
        List<Address> addresses = new ArrayList<>();
        try {
            InetAddress[] inetAddresses = InetAddress.getAllByName(dnsQuery);
            logger.debug("DNS lookup: {}", Arrays.toString(inetAddresses));
            for (InetAddress address : inetAddresses) {
                addresses.add(new IpAddress(address.getHostAddress(), Integer.parseInt(bindPort)));
            }
        } catch (UnknownHostException ex) {
            logger.warn("failed to resolve query {}, ex: {}", dnsQuery, ex);
        }
        return addresses;
    }
}
