package com.turbospaces.infinispan;

import org.jgroups.JChannel;
import org.jgroups.blocks.ReplicatedHashMap;
import org.junit.jupiter.api.Test;

import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.plugins.JGroupsBootstrapInitializer;

public class JgroupsPluginTest {
    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        ApplicationConfig cfg = builder.build();

        SimpleBootstrap bootstrap = new SimpleBootstrap( JgroupsPluginTest.class, new ApplicationProperties( cfg ) );
        bootstrap.addBootstrapRegistryInitializer( new JGroupsBootstrapInitializer() );
        bootstrap.run();

        try {
            JChannel channel = bootstrap.context().getBean( JChannel.class );

            try (ReplicatedHashMap<String, Object> cache = new ReplicatedHashMap<>( channel )) {
                channel.connect( getClass().getSimpleName() );

                cache.start( 30 * 10000 );
                cache.put( "1", 1 );
                cache.put( "2", 2 );
                cache.clear();
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }
}
