package com.turbospaces.plugins;

import org.jgroups.JChannel;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistry.InstanceSupplier;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.jgroups.DNSPingChannel;
import com.turbospaces.jgroups.JChannelDisposableBean;

public class JGroupsBootstrapInitializer extends AbstractBootstrapAware implements BootstrapRegistryInitializer, Ordered {
    private final boolean discardOwnMessages;

    public JGroupsBootstrapInitializer() {
        this( true );
    }
    public JGroupsBootstrapInitializer(boolean discardOwnMessages) {
        this.discardOwnMessages = discardOwnMessages;
    }
    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }
    @Override
    public void initialize(BootstrapRegistry registry) {
        try {
            JChannel channel = bootstrap.isDevMode() ? new JChannel() : new DNSPingChannel( bootstrap.props() );
            channel.setDiscardOwnMessages( discardOwnMessages );
            channel.connect( bootstrap.props().CLOUD_APP_SPACE_NAME.get() );

            registry.register( JChannel.class, InstanceSupplier.of( channel ) );
            registry.addCloseListener( new ApplicationListener<BootstrapContextClosedEvent>() {
                @Override
                public void onApplicationEvent(BootstrapContextClosedEvent event) {
                    ConfigurableApplicationContext applicationContext = event.getApplicationContext();
                    applicationContext.addApplicationListener( new SmartApplicationListener() {
                        @Override
                        public void onApplicationEvent(ApplicationEvent e) {
                            channel.close();
                        }
                        @Override
                        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
                            return eventType.equals( ApplicationFailedEvent.class );
                        }
                    } );

                    DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory) applicationContext.getBeanFactory();
                    beanFactory.registerSingleton( "jgroups", channel );

                    // ~ shutdown gracefully
                    GenericBeanDefinition bean = new GenericBeanDefinition();
                    bean.setBeanClass( JChannelDisposableBean.class );
                    bean.setAutowireCandidate( true );
                    beanFactory.registerBeanDefinition( "jgroups-lifecycle", bean );
                }
            } );
        }
        catch ( Exception err ) {
            throw new BeanCreationException( err.getMessage(), err );
        }
    }
}
