/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.plugins;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.jgroups.DNSPingChannel;
import com.turbospaces.jgroups.JChannelDisposableBean;
import org.jgroups.JChannel;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;

public class JGroupsBootstrapInitializer
extends AbstractBootstrapAware
implements BootstrapRegistryInitializer,
Ordered {
    private final boolean discardOwnMessages;

    public JGroupsBootstrapInitializer() {
        this(true);
    }

    public JGroupsBootstrapInitializer(boolean discardOwnMessages) {
        this.discardOwnMessages = discardOwnMessages;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void initialize(BootstrapRegistry registry) {
        try {
            final JChannel channel = this.bootstrap.isDevMode() ? new JChannel() : new DNSPingChannel(this.bootstrap.props());
            channel.setDiscardOwnMessages(this.discardOwnMessages);
            channel.connect((String)this.bootstrap.props().CLOUD_APP_SPACE_NAME.get());
            registry.register(JChannel.class, BootstrapRegistry.InstanceSupplier.of((Object)channel));
            registry.addCloseListener((ApplicationListener)new ApplicationListener<BootstrapContextClosedEvent>(){

                public void onApplicationEvent(BootstrapContextClosedEvent event) {
                    ConfigurableApplicationContext applicationContext = event.getApplicationContext();
                    applicationContext.addApplicationListener((ApplicationListener)new SmartApplicationListener(){

                        public void onApplicationEvent(ApplicationEvent e) {
                            channel.close();
                        }

                        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
                            return eventType.equals(ApplicationFailedEvent.class);
                        }
                    });
                    DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
                    beanFactory.registerSingleton("jgroups", (Object)channel);
                    GenericBeanDefinition bean = new GenericBeanDefinition();
                    bean.setBeanClass(JChannelDisposableBean.class);
                    bean.setAutowireCandidate(true);
                    beanFactory.registerBeanDefinition("jgroups-lifecycle", (BeanDefinition)bean);
                }
            });
        }
        catch (Exception err) {
            throw new BeanCreationException(err.getMessage(), (Throwable)err);
        }
    }
}

