/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.jgroups;

import com.turbospaces.cfg.ApplicationProperties;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jgroups.JChannel;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.protocols.dns.DNS_PING;
import org.jgroups.protocols.dns.TypeADNSResolver;
import org.jgroups.stack.ProtocolStack;
import org.springframework.util.ResourceUtils;

public class DNSPingChannel
extends JChannel {
    public DNSPingChannel(final ApplicationProperties props) throws Exception {
        super(false);
        this.prot_stack = new ProtocolStack(this){

            public void initProtocolStack() throws Exception {
                String query = (String)props.APP_DNS_QUERY.get();
                if (StringUtils.isEmpty((CharSequence)query)) {
                    query = (String)props.CLOUD_APP_ID.get();
                }
                DNS_PING ping = (DNS_PING)this.findProtocol(DNS_PING.class);
                ping.setValue("dns_query", (Object)query);
                ping.setValue("dns_record_type", (Object)"A");
                ping.setValue("dns_resolver", (Object)new TypeADNSResolver());
                super.initProtocolStack();
            }
        };
        URL url = ResourceUtils.getURL((String)"classpath:dns-ping-jgroups-tcp.xml");
        try (InputStream in = url.openStream();){
            XmlConfigurator xml = (XmlConfigurator)ConfiguratorFactory.getStackConfigurator((InputStream)in);
            List configs = xml.getProtocolStack();
            for (ProtocolConfiguration cfg : configs) {
                cfg.substituteVariables();
            }
            this.prot_stack.setup(configs);
        }
    }
}

