package com.turbospaces.jgroups;

import java.util.Objects;

import org.jgroups.JChannel;
import org.springframework.beans.factory.config.AbstractFactoryBean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public class JGroupsFactoryBean extends AbstractFactoryBean<JChannel> implements BootstrapAware {
    private Bootstrap bootstrap;

    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }
    @Override
    public Class<?> getObjectType() {
        return JChannel.class;
    }
    @Override
    protected JChannel createInstance() throws Exception {
        JChannel channel = bootstrap.isDevMode() ? new JChannel() : new DNSPingChannel(bootstrap.props());
        channel.setDiscardOwnMessages(true);
        channel.connect(bootstrap.props().CLOUD_APP_SPACE_NAME.get());
        return channel;
    }
    @Override
    protected void destroyInstance(JChannel instance) throws Exception {
        if (Objects.nonNull(instance)) {
            instance.close();
        }
    }
}
