/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.stack.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeADNSResolver
implements DNSResolver {
    public static final int DEFAULT_COMMUNICATION_PORT = 6800;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<Address> resolveIps(String dnsQuery, DNSResolver.DNSRecordType recordType) {
        String bindPort = System.getProperty("jgroups.bind_port", Integer.toString(6800));
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            Object[] inetAddresses = InetAddress.getAllByName(dnsQuery);
            this.logger.debug("DNS lookup: {}", (Object)Arrays.toString(inetAddresses));
            for (Object address : inetAddresses) {
                addresses.add((Address)new IpAddress(((InetAddress)address).getHostAddress(), Integer.parseInt(bindPort)));
            }
        }
        catch (UnknownHostException ex) {
            this.logger.warn("failed to resolve query {}, ex: {}", (Object)dnsQuery, (Object)ex);
        }
        return addresses;
    }
}

