/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.jgroups;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.jgroups.DNSPingChannel;
import java.util.Objects;
import org.jgroups.JChannel;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JGroupsFactoryBean
extends AbstractFactoryBean<JChannel>
implements BootstrapAware {
    private Bootstrap bootstrap;

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }

    public Class<?> getObjectType() {
        return JChannel.class;
    }

    protected JChannel createInstance() throws Exception {
        JChannel channel = this.bootstrap.isDevMode() ? new JChannel() : new DNSPingChannel(this.bootstrap.props());
        channel.setDiscardOwnMessages(true);
        channel.connect((String)this.bootstrap.props().CLOUD_APP_SPACE_NAME.get());
        return channel;
    }

    protected void destroyInstance(JChannel instance) throws Exception {
        if (Objects.nonNull(instance)) {
            instance.close();
        }
    }
}

