/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.cache.BlockhoundCacheWrapper;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.AbstractEbeanCache;
import com.turbospaces.ebean.BroadcastChannel;
import com.turbospaces.ebean.ReplicatedCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.config.CurrentTenantProvider;
import java.io.IOException;
import java.util.Objects;

public class ReplicatedEbeanCache
extends AbstractEbeanCache
implements ReplicatedCache {
    private final BroadcastChannel dispatcher;

    public ReplicatedEbeanCache(ApplicationProperties props, String cacheKey, BlockhoundCacheWrapper<String, Object> cache, CurrentTenantProvider tenantProvider, ServerCacheConfig config, BroadcastChannel dispatcher) {
        super(props, cacheKey, cache, tenantProvider, config);
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    @Override
    public void put(Object id, Object obj) {
        String key = this.key(id);
        super.put(id, obj);
        this.dispatcher.broadcastPutAsync(this.cacheKey(), this.type(), key, obj);
    }

    @Override
    public void remove(Object id) {
        String key = this.key(id);
        super.remove(id);
        this.dispatcher.broadcastRemoveAsync(this.cacheKey(), key);
    }

    @Override
    public void clear() {
        super.clear();
        this.dispatcher.broadcastClearAllAsync();
    }

    @Override
    public void onRemove(byte[] data) {
        super.onRemove(data);
    }

    @Override
    public int onClear() {
        return super.onClear();
    }

    @Override
    public void onPut(byte[] keyData, byte[] valueData) throws IOException {
        super.onPut(keyData, valueData);
    }
}

