/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.archaius.api.Config;
import com.turbospaces.cache.BlockhoundCacheWrapper;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.BroadcastChannel;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.LocalCache;
import com.turbospaces.ebean.LocalEbeanCache;
import com.turbospaces.ebean.ReplicatedCache;
import io.ebean.BackgroundExecutor;
import io.ebean.DatabaseBuilder;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jgroups.util.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(MockCacheManager.class);
    private final ApplicationProperties props;
    private final Map<String, ServerCache> caches = Maps.newConcurrentMap();
    private BackgroundExecutor executor;

    public MockCacheManager(ApplicationProperties props) {
        this.props = Objects.requireNonNull(props);
    }

    @Override
    public void setBackgroundExecutor(BackgroundExecutor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public ServerCacheFactory create(DatabaseBuilder databaseBuilder, BackgroundExecutor backgroupExecutor) {
        this.setBackgroundExecutor(backgroupExecutor);
        return this;
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify listener) {
        return new ServerCacheNotify(this){

            public void notify(ServerCacheNotification notification) {
            }
        };
    }

    public ServerCache createCache(ServerCacheConfig config) {
        String cacheKey = config.getCacheKey();
        String shortName = config.getShortName();
        ServerCacheOptions cacheOptions = config.getCacheOptions();
        ServerCacheType cacheType = config.getType();
        CurrentTenantProvider tenantProvider = config.getTenantProvider();
        QueryCacheEntryValidate queryCacheValidate = config.getQueryCacheEntryValidate();
        ServerCache cache = this.caches.get(cacheKey);
        if (Objects.isNull(cache)) {
            Config prefixedView = this.props.cfg().getPrefixedView(cacheKey);
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            for (String key : prefixedView.keys()) {
                Object rawProperty = prefixedView.getRawProperty(key);
                configMap.put(key, rawProperty);
            }
            int maxTtl = prefixedView.getInteger("max-ttl", Integer.valueOf(cacheOptions.getMaxSecsToLive()));
            int maxIdle = prefixedView.getInteger("max-idle", Integer.valueOf(cacheOptions.getMaxIdleSecs()));
            int maxSize = prefixedView.getInteger("max-size", Integer.valueOf(cacheOptions.getMaxSize()));
            int trimFrequency = (int)((Duration)this.props.APP_TIMER_INTERVAL.get()).toSeconds();
            ServerCacheOptions options = new ServerCacheOptions();
            options.setMaxSecsToLive(maxTtl);
            options.setMaxIdleSecs(maxIdle);
            options.setMaxSize(maxSize);
            options.setTrimFrequency(trimFrequency);
            ServerCacheConfig scc = new ServerCacheConfig(cacheType, cacheKey, shortName, options, tenantProvider, queryCacheValidate);
            if (config.isQueryCache()) {
                cache = new DefaultServerQueryCache(new DefaultServerCacheConfig(scc));
                ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                if (Objects.nonNull(prev)) {
                    cache = prev;
                } else {
                    log.debug("created query cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
                }
            } else {
                if (BooleanUtils.isFalse((Boolean)prefixedView.containsKey("cache-mode-local"))) {
                    if (this.props.isProdMode()) {
                        log.error("cache {} is not configured", (Object)cacheKey);
                    } else {
                        throw new IllegalStateException("cache %s is not configured".formatted(cacheKey));
                    }
                }
                ToStringStyle nameStyle = ToStringStyle.NO_CLASS_NAME_STYLE;
                Cache<String, Object> holder = LocalCache.cache(cacheKey, new DefaultServerCacheConfig(scc));
                BlockhoundCacheWrapper cacheWrapper = new BlockhoundCacheWrapper(holder);
                cache = new LocalEbeanCache(this.props, cacheKey, (BlockhoundCacheWrapper<String, Object>)cacheWrapper, tenantProvider, scc, new BroadcastChannel(this){
                    private final RspList<Object> list = new RspList();
                    private final CompletableFuture<RspList<Object>> completable = CompletableFuture.completedFuture(this.list);
                    private final ListenableFuture<CompletableFuture<RspList<Object>>> toReturn = Futures.immediateFuture(this.completable);

                    @Override
                    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastPutAsync(String cacheName, ServerCacheType type, String key, Object obj) {
                        return FluentFuture.from(this.toReturn);
                    }

                    @Override
                    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastRemoveAsync(String cacheName, String key) {
                        return FluentFuture.from(this.toReturn);
                    }

                    @Override
                    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastClearAllAsync(String cacheName) {
                        return FluentFuture.from(this.toReturn);
                    }

                    @Override
                    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastClearAllAsync() {
                        return FluentFuture.from(this.toReturn);
                    }

                    @Override
                    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastAsync(ServerCacheNotification notification, String data) {
                        return FluentFuture.from(this.toReturn);
                    }
                });
                ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                if (Objects.nonNull(prev)) {
                    cache = prev;
                } else {
                    log.debug("created local cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)nameStyle));
                }
            }
            final ServerCache tmp = Objects.requireNonNull(cache);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (tmp instanceof LocalEbeanCache) {
                        ((LocalEbeanCache)tmp).cleanUp();
                    } else if (tmp instanceof ReplicatedCache) {
                        ((ReplicatedCache)tmp).cleanUp();
                    } else if (tmp instanceof DefaultServerQueryCache) {
                        ((DefaultServerQueryCache)tmp).runEviction();
                    }
                }
            }, (long)trimFrequency, (long)trimFrequency, TimeUnit.SECONDS);
        }
        return cache;
    }

    @Override
    public ServerCache getCache(String string) {
        return this.caches.get(string);
    }

    @Override
    public void clearAll() {
        for (ServerCache cache : this.caches.values()) {
            if (!(cache instanceof LocalEbeanCache)) continue;
            ((LocalEbeanCache)cache).onClear();
        }
    }
}

