/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.turbospaces.ebean.ClearableCache;
import com.turbospaces.ebean.RemovableCache;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.ServerCacheType;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LocalCache
extends ServerCache,
ClearableCache,
RemovableCache {
    public String cacheKey();

    public ServerCacheType type();

    public void cleanUp();

    public static ServerCacheStatistics stats(String cacheKey, Cache<String, Object> cache) {
        CacheStats stats = cache.stats();
        ServerCacheStatistics scs = new ServerCacheStatistics();
        scs.setCacheName(cacheKey);
        scs.setEvictCount(stats.evictionCount());
        scs.setHitCount(stats.hitCount());
        scs.setMissCount(stats.missCount());
        scs.setSize((int)cache.size());
        return scs;
    }

    public static Cache<String, Object> cache(final String cacheKey, DefaultServerCacheConfig cfg) {
        final Logger logger = LoggerFactory.getLogger(LocalCache.class);
        return CacheBuilder.newBuilder().maximumSize((long)cfg.getMaxSize()).expireAfterAccess((long)cfg.getMaxIdleSecs(), TimeUnit.SECONDS).expireAfterWrite((long)cfg.getMaxSecsToLive(), TimeUnit.SECONDS).recordStats().removalListener((RemovalListener)new RemovalListener<Object, Object>(){
            private final EnumSet<RemovalCause> reasons = EnumSet.of(RemovalCause.EXPIRED, RemovalCause.SIZE);

            public void onRemoval(RemovalNotification<Object, Object> notification) {
                if (Objects.nonNull(notification.getCause()) && this.reasons.contains(notification.getCause()) && logger.isTraceEnabled()) {
                    String type = notification.getCause().name().toLowerCase().intern();
                    logger.trace("onRemoval({}): {} {}", new Object[]{cacheKey, type, notification});
                }
            }
        }).build();
    }
}

