/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.archaius.api.Config;
import com.turbospaces.cache.BlockhoundCacheWrapper;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.ebean.AbstractEbeanCache;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.ClearableCache;
import com.turbospaces.ebean.JGroupsBroadcastChannel;
import com.turbospaces.ebean.JgroupsServerQueryCache;
import com.turbospaces.ebean.LocalCache;
import com.turbospaces.ebean.LocalEbeanCache;
import com.turbospaces.ebean.ReplicatedCache;
import com.turbospaces.ebean.ReplicatedEbeanCache;
import io.ebean.BackgroundExecutor;
import io.ebean.DatabaseBuilder;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RpcDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JGroupsCacheManager
implements MethodLookup,
CacheManager,
ServerCacheNotify,
InitializingBean,
DisposableBean,
BeanNameAware {
    private static final Logger log = LoggerFactory.getLogger(JGroupsCacheManager.class);
    public static short METHOD_ON_CACHE_PUT = 1;
    public static short METHOD_ON_CHANGE_REMOVE = (short)2;
    public static short METHOD_ON_CACHE_CLEAR = (short)3;
    public static short METHOD_ON_MODIFIED = (short)4;
    public static short METHOD_ON_CACHE_CLEAR_ALL = (short)5;
    public static ImmutableMap<Short, Method> METHODS;
    private final ApplicationProperties props;
    private final MeterRegistry meterRegistry;
    private final JGroupsBroadcastChannel broadcast;
    private final ConcurrentMap<String, ServerCache> caches;
    private final ScheduledExecutorService timer;
    private String beanName;
    private BackgroundExecutor executor;
    private ServerCacheNotify notify;

    public JGroupsCacheManager(ApplicationProperties props, MeterRegistry meterRegistry, RpcDispatcher dispatcher) {
        this.props = Objects.requireNonNull(props);
        this.meterRegistry = Objects.requireNonNull(meterRegistry);
        this.broadcast = new JGroupsBroadcastChannel(props, meterRegistry, dispatcher);
        this.caches = Maps.newConcurrentMap();
        this.timer = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                if (StringUtils.isNotEmpty((CharSequence)JGroupsCacheManager.this.beanName)) {
                    t.setName(JGroupsCacheManager.this.beanName);
                }
                return t;
            }
        });
    }

    public void setBeanName(String name) {
        this.beanName = Objects.requireNonNull(name);
    }

    public void afterPropertiesSet() throws Exception {
        this.broadcast.afterPropertiesSet();
        long intervalMillis = ((Duration)this.props.CACHE_METRICS_REPORT_INTERVAL.get()).toMillis();
        this.timer.scheduleWithFixedDelay(() -> this.caches.forEach((key, value) -> {
            if (key.endsWith(ServerCacheType.QUERY.code())) {
                ServerCacheStatistics stats = value.statistics(true);
                this.meterRegistry.counter("query_cache.hits", new String[]{"name", key}).increment((double)stats.getHitCount());
                this.meterRegistry.counter("query_cache.puts", new String[]{"name", key}).increment((double)stats.getPutCount());
                this.meterRegistry.counter("query_cache.evicts", new String[]{"name", key}).increment((double)stats.getEvictCount());
                this.meterRegistry.gauge("query_cache.size", (Iterable)Tags.of((String)"name", (String)key), (Number)stats.getSize());
                this.meterRegistry.gauge("query_cache.maxSize", (Iterable)Tags.of((String)"name", (String)key), (Number)stats.getMaxSize());
                this.meterRegistry.gauge("query_cache.hit_ratio", (Iterable)Tags.of((String)"name", (String)key), (Number)stats.getHitRatio());
                this.meterRegistry.counter("query_cache.miss_count", new String[]{"name", key}).increment((double)stats.getMissCount());
                this.meterRegistry.counter("query_cache.ttl_count", new String[]{"name", key}).increment((double)stats.getTtlCount());
                this.meterRegistry.counter("query_cache.remove_count", new String[]{"name", key}).increment((double)stats.getRemoveCount());
                this.meterRegistry.counter("query_cache.clear_count", new String[]{"name", key}).increment((double)stats.getClearCount());
                this.meterRegistry.counter("query_cache.idle_count", new String[]{"name", key}).increment((double)stats.getIdleCount());
            }
        }), intervalMillis, intervalMillis, TimeUnit.MILLISECONDS);
        if (Objects.isNull(this.executor)) {
            this.setBackgroundExecutor(new BackgroundExecutor(){

                public Future<?> submit(Runnable task) {
                    return JGroupsCacheManager.this.timer.submit(task);
                }

                public <T> Future<T> submit(Callable<T> task) {
                    return JGroupsCacheManager.this.timer.submit(task);
                }

                public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
                    return JGroupsCacheManager.this.timer.scheduleWithFixedDelay(task, initialDelay, delay, unit);
                }

                public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
                    return JGroupsCacheManager.this.timer.scheduleAtFixedRate(task, initialDelay, period, unit);
                }

                public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
                    return JGroupsCacheManager.this.timer.schedule(task, delay, unit);
                }

                public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
                    return JGroupsCacheManager.this.timer.schedule(task, delay, unit);
                }

                public void execute(Runnable task) {
                    JGroupsCacheManager.this.timer.execute(task);
                }
            });
        }
    }

    public void destroy() throws Exception {
        try {
            this.broadcast.destroy();
        }
        finally {
            PlatformUtil.shutdownExecutor((ExecutorService)this.timer, (Duration)((Duration)this.props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.get()));
        }
    }

    public Method findMethod(short id) {
        return (Method)METHODS.get((Object)id);
    }

    @Override
    public void setBackgroundExecutor(BackgroundExecutor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public ServerCacheFactory create(DatabaseBuilder databaseBuilder, BackgroundExecutor backgroundExecutor) {
        this.setBackgroundExecutor(backgroundExecutor);
        return this;
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify cacheNotify) {
        this.notify = Objects.requireNonNull(cacheNotify);
        return this;
    }

    public void notify(ServerCacheNotification notification) {
        if (CollectionUtils.isNotEmpty((Collection)notification.getDependentTables())) {
            Set dependentTables = notification.getDependentTables();
            String line = Joiner.on((char)',').join((Iterable)dependentTables);
            log.debug("Publish TableMods - {}", (Object)line);
            this.broadcast.broadcastAsync(notification, line);
        }
    }

    @Override
    public void onTablesModify(String line) {
        Iterable it = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)line);
        ImmutableSet tables = ImmutableSet.copyOf((Iterable)it);
        ServerCacheNotification notification = new ServerCacheNotification((Set)tables);
        if (Objects.nonNull(this.notify)) {
            this.notify.notify(notification);
        }
    }

    @Override
    public void onCachePut(String cacheKey, byte[] id, byte[] value) throws Throwable {
        AbstractEbeanCache cache = (AbstractEbeanCache)this.caches.get(cacheKey);
        if (Objects.nonNull(cache)) {
            cache.onPut(id, value);
        }
    }

    @Override
    public void onCacheRemove(String cacheKey, byte[] id) throws Throwable {
        AbstractEbeanCache cache = (AbstractEbeanCache)this.caches.get(cacheKey);
        if (Objects.nonNull(cache)) {
            cache.onRemove(id);
        }
    }

    @Override
    public void onCacheClear(String cacheKey) throws Throwable {
        ServerCache cache = (ServerCache)this.caches.get(cacheKey);
        if (Objects.nonNull(cache) && cache instanceof ClearableCache) {
            ((ClearableCache)cache).onClear();
        }
    }

    @Override
    public void onCacheClearAll(boolean preserveSimple) throws Throwable {
        this.onCacheClearAll();
    }

    @Override
    public void onCacheClearAll() throws Throwable {
        for (ServerCache cache : this.caches.values()) {
            if (!(cache instanceof ClearableCache)) continue;
            ((ClearableCache)cache).onClear();
        }
    }

    @Override
    public ServerCache getCache(String cacheKey) {
        return (ServerCache)this.caches.get(cacheKey);
    }

    @Override
    public void clearAll() {
        try {
            this.onCacheClearAll();
        }
        catch (Throwable err) {
            log.error(err.getMessage(), err);
        }
        finally {
            this.broadcast.broadcastClearAllAsync();
        }
    }

    public ServerCache createCache(ServerCacheConfig config) {
        String cacheKey = config.getCacheKey();
        String shortName = config.getShortName();
        ServerCacheOptions cacheOptions = config.getCacheOptions();
        ServerCacheType cacheType = config.getType();
        CurrentTenantProvider tenantProvider = config.getTenantProvider();
        QueryCacheEntryValidate queryCacheValidate = config.getQueryCacheEntryValidate();
        Object cache = (ServerCache)this.caches.get(cacheKey);
        if (Objects.isNull(cache)) {
            Config prefixedView = this.props.cfg().getPrefixedView(cacheKey);
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            for (String key : prefixedView.keys()) {
                Object rawProperty = prefixedView.getRawProperty(key);
                configMap.put(key, rawProperty);
            }
            int maxTtl = prefixedView.getInteger("max-ttl", Integer.valueOf(cacheOptions.getMaxSecsToLive()));
            int maxIdle = prefixedView.getInteger("max-idle", Integer.valueOf(cacheOptions.getMaxIdleSecs()));
            int maxSize = prefixedView.getInteger("max-size", Integer.valueOf(cacheOptions.getMaxSize()));
            int trimFrequency = (int)((Duration)this.props.APP_TIMER_INTERVAL.get()).toSeconds();
            ServerCacheOptions options = new ServerCacheOptions();
            options.setMaxSecsToLive(maxTtl);
            options.setMaxIdleSecs(maxIdle);
            options.setMaxSize(maxSize);
            options.setTrimFrequency(trimFrequency);
            ServerCacheConfig scc = new ServerCacheConfig(cacheType, cacheKey, shortName, options, tenantProvider, queryCacheValidate);
            ArrayList tags = Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"cacheType", (String)cacheType.name().toLowerCase()), Tag.of((String)"shortName", (String)shortName)});
            if (config.isQueryCache()) {
                cache = new JgroupsServerQueryCache(this.props, new DefaultServerCacheConfig(scc), this.broadcast);
                ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                if (Objects.nonNull(prev)) {
                    cache = prev;
                } else {
                    log.debug("created query cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
                }
            } else {
                if (BooleanUtils.isFalse((Boolean)prefixedView.containsKey("cache-mode-local"))) {
                    if (((Boolean)this.props.APP_DEV_MODE.get()).booleanValue()) {
                        throw new IllegalStateException("cache %s is not configured".formatted(cacheKey));
                    }
                    log.error("cache {} is not configured", (Object)cacheKey);
                }
                boolean localMode = prefixedView.getBoolean("cache-mode-local", Boolean.valueOf(false));
                ToStringStyle nameStyle = ToStringStyle.NO_CLASS_NAME_STYLE;
                Cache<String, Object> holder = LocalCache.cache(cacheKey, new DefaultServerCacheConfig(scc));
                BlockhoundCacheWrapper cacheWrapper = new BlockhoundCacheWrapper(holder);
                if (localMode) {
                    cache = new LocalEbeanCache(this.props, cacheKey, (BlockhoundCacheWrapper<String, Object>)cacheWrapper, tenantProvider, scc, this.broadcast);
                    ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                    if (Objects.nonNull(prev)) {
                        cache = prev;
                    } else {
                        new GuavaCacheMetrics(holder, cacheKey, (Iterable)tags).bindTo(this.meterRegistry);
                        log.debug("created local cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)nameStyle));
                    }
                } else {
                    cache = new ReplicatedEbeanCache(this.props, cacheKey, (BlockhoundCacheWrapper<String, Object>)cacheWrapper, tenantProvider, scc, this.broadcast);
                    ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                    if (Objects.nonNull(prev)) {
                        cache = prev;
                    } else {
                        new GuavaCacheMetrics(holder, cacheKey, (Iterable)tags).bindTo(this.meterRegistry);
                        log.debug("created replicated cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)nameStyle));
                    }
                }
            }
            final ServerCache tmp = Objects.requireNonNull(cache);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (tmp instanceof LocalEbeanCache) {
                        ((LocalEbeanCache)tmp).cleanUp();
                    } else if (tmp instanceof ReplicatedCache) {
                        ((ReplicatedCache)tmp).cleanUp();
                    } else if (tmp instanceof DefaultServerQueryCache) {
                        ((DefaultServerQueryCache)tmp).runEviction();
                    }
                }
            }, (long)trimFrequency, (long)trimFrequency, TimeUnit.SECONDS);
        }
        return cache;
    }

    static {
        try {
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.put((Object)METHOD_ON_MODIFIED, (Object)JGroupsCacheManager.class.getMethod("onTablesModify", String.class));
            b.put((Object)METHOD_ON_CACHE_PUT, (Object)JGroupsCacheManager.class.getMethod("onCachePut", String.class, byte[].class, byte[].class));
            b.put((Object)METHOD_ON_CHANGE_REMOVE, (Object)JGroupsCacheManager.class.getMethod("onCacheRemove", String.class, byte[].class));
            b.put((Object)METHOD_ON_CACHE_CLEAR, (Object)JGroupsCacheManager.class.getMethod("onCacheClear", String.class));
            b.put((Object)METHOD_ON_CACHE_CLEAR_ALL, (Object)JGroupsCacheManager.class.getMethod("onCacheClearAll", Boolean.TYPE));
            METHODS = b.build();
        }
        catch (NoSuchMethodException err) {
            throw new Error(err);
        }
    }
}

