/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.ebean.BroadcastChannel;
import com.turbospaces.ebean.JGroupsCacheManager;
import com.turbospaces.executor.DefaultPlatformExecutorService;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheType;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedManyIds;
import io.micrometer.core.instrument.MeterRegistry;
import io.vavr.CheckedFunction0;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.commons.lang3.time.StopWatch;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JGroupsBroadcastChannel
implements BroadcastChannel,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JGroupsBroadcastChannel.class);
    private final RpcDispatcher dispatcher;
    private final DefaultPlatformExecutorService platform;

    public JGroupsBroadcastChannel(ApplicationProperties props, MeterRegistry meterRegistry, RpcDispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.platform = new DefaultPlatformExecutorService(props, meterRegistry, ((Integer)props.APP_PLATFORM_POOL_SIZE.get()).intValue());
        this.platform.setBeanName("jgroups-rpc-dispatcher");
    }

    public void afterPropertiesSet() throws Exception {
        this.platform.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        this.platform.destroy();
    }

    @Override
    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastPutAsync(final String cacheKey, ServerCacheType type, final String key, final Object obj) {
        UnsynchronizedByteArrayOutputStream out = UnsynchronizedByteArrayOutputStream.builder().get();
        final byte[] kser = PlatformUtil.serialize((UnsynchronizedByteArrayOutputStream)out, (Serializable)((Object)key));
        final byte[] vser = switch (type) {
            case ServerCacheType.NATURAL_KEY -> PlatformUtil.serialize((UnsynchronizedByteArrayOutputStream)out, (Serializable)((Serializable)Serializable.class.cast(obj)));
            case ServerCacheType.BEAN -> PlatformUtil.serialize((UnsynchronizedByteArrayOutputStream)out, (Externalizable)((Externalizable)CachedBeanData.class.cast(obj)));
            case ServerCacheType.COLLECTION_IDS -> PlatformUtil.serialize((UnsynchronizedByteArrayOutputStream)out, (Externalizable)((Externalizable)CachedManyIds.class.cast(obj)));
            default -> throw new IllegalArgumentException("Unexpected cache type: " + String.valueOf(type));
        };
        out.reset();
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture fluent = FluentFuture.from((ListenableFuture)this.platform.submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (JGroupsBroadcastChannel.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_PUT, new Object[]{cacheKey, kser, vser});
                    future = JGroupsBroadcastChannel.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        }));
        fluent.addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                log.trace("putted {} entry on remote nodes by key: {} value: {} in: {}", new Object[]{cacheKey, key, obj, stopWatch});
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    log.error("put operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                log.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
        return fluent;
    }

    @Override
    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastRemoveAsync(final String cacheKey, final String key) {
        UnsynchronizedByteArrayOutputStream out = UnsynchronizedByteArrayOutputStream.builder().get();
        final byte[] kser = PlatformUtil.serialize((UnsynchronizedByteArrayOutputStream)out, (Serializable)((Object)key));
        out.reset();
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture fluent = FluentFuture.from((ListenableFuture)this.platform.submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (JGroupsBroadcastChannel.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CHANGE_REMOVE, new Object[]{cacheKey, kser});
                    future = JGroupsBroadcastChannel.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        }));
        fluent.addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                log.trace("removed {} entry on remote nodes by key: {} in: {}", new Object[]{cacheKey, key, stopWatch});
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    log.error("remove operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                log.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
        return fluent;
    }

    @Override
    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastClearAllAsync(final String cacheKey) {
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture fluent = FluentFuture.from((ListenableFuture)this.platform.submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (JGroupsBroadcastChannel.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_CLEAR, new Object[]{cacheKey});
                    future = JGroupsBroadcastChannel.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        }));
        fluent.addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                log.info("cleared {} on remote nodes in: {}", (Object)cacheKey, (Object)stopWatch);
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    log.error("clear operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                log.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
        return fluent;
    }

    @Override
    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastClearAllAsync() {
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture fluent = FluentFuture.from((ListenableFuture)this.platform.submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (JGroupsBroadcastChannel.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_CLEAR_ALL, new Object[]{true});
                    future = JGroupsBroadcastChannel.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        }));
        fluent.addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    log.error("clearAll operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                log.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
        return fluent;
    }

    @Override
    public FluentFuture<CompletableFuture<RspList<Object>>> broadcastAsync(final ServerCacheNotification notification, final String data) {
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture fluent = FluentFuture.from((ListenableFuture)this.platform.submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (JGroupsBroadcastChannel.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_MODIFIED, new Object[]{data});
                    future = JGroupsBroadcastChannel.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        }));
        fluent.addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    log.error("notify operation took too long: {} for tables: {}", (Object)stopWatch, (Object)notification.getDependentTables());
                }
            }

            public void onFailure(Throwable t) {
                log.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
        return fluent;
    }
}

