/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.JGroupsCacheManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JGroupCacheManagerFactoryBean
extends AbstractFactoryBean<CacheManager> {
    private final ApplicationProperties props;
    private final MeterRegistry meterRegistry;
    private final JChannel jchannel;
    private final RpcDispatcher dispatcher = new RpcDispatcher();

    public JGroupCacheManagerFactoryBean(ApplicationProperties props, MeterRegistry meterRegistry, JChannel jchannel) {
        this.props = Objects.requireNonNull(props);
        this.meterRegistry = Objects.requireNonNull(meterRegistry);
        this.jchannel = Objects.requireNonNull(jchannel);
    }

    public Class<?> getObjectType() {
        return CacheManager.class;
    }

    protected CacheManager createInstance() throws Exception {
        while (true) {
            try {
                JGroupsCacheManager manager = new JGroupsCacheManager(this.props, this.meterRegistry, this.dispatcher);
                manager.afterPropertiesSet();
                this.dispatcher.setAsynDispatching(true);
                this.dispatcher.setChannel(this.jchannel);
                this.dispatcher.setServerObject((Object)manager);
                this.dispatcher.setMethodLookup((MethodLookup)manager);
                this.dispatcher.start();
                return manager;
            }
            catch (Throwable err) {
                ExceptionUtils.wrapAndThrow((Throwable)err);
                continue;
            }
            break;
        }
    }

    protected void destroyInstance(CacheManager instance) throws Exception {
        this.dispatcher.close();
    }
}

