/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.cache.BlockhoundCacheWrapper;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.ebean.LocalCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.ServerCacheType;
import io.ebean.cache.TenantAwareKey;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedManyIds;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEbeanCache
implements LocalCache {
    private static final Logger log = LoggerFactory.getLogger(AbstractEbeanCache.class);
    private final ApplicationProperties props;
    private final String cacheKey;
    private final BlockhoundCacheWrapper<String, Object> cache;
    private final TenantAwareKey tenantAwareKey;
    private final ServerCacheConfig config;

    protected AbstractEbeanCache(ApplicationProperties props, String cacheKey, BlockhoundCacheWrapper<String, Object> cache, CurrentTenantProvider tenantProvider, ServerCacheConfig config) {
        this.props = Objects.requireNonNull(props);
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.cache = Objects.requireNonNull(cache);
        this.tenantAwareKey = new TenantAwareKey(tenantProvider);
        this.config = Objects.requireNonNull(config);
    }

    public Object get(Object id) {
        String key = this.key(id);
        return this.cache.getIfPresent((Object)key);
    }

    public void put(Object id, Object obj) {
        String key = this.key(id);
        this.cache.put((Object)key, obj);
    }

    public void remove(Object id) {
        String key = this.key(id);
        this.cache.invalidate((Object)key);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public int size() {
        return (int)this.cache.size();
    }

    @Override
    public void cleanUp() {
        this.cache.cleanUp();
    }

    public int hitRatio() {
        return (int)(this.cache.stats().hitRate() * 100.0);
    }

    public ServerCacheStatistics statistics(boolean reset) {
        return LocalCache.stats(this.cacheKey, this.cache);
    }

    @Override
    public ServerCacheType type() {
        return this.config.getType();
    }

    @Override
    public String cacheKey() {
        return this.cacheKey;
    }

    public String toString() {
        return this.cacheKey();
    }

    public int hashCode() {
        return Objects.hash(this.cacheKey());
    }

    public boolean equals(Object obj) {
        return Objects.equals(this.cacheKey, ((AbstractEbeanCache)obj).cacheKey());
    }

    @Override
    public void onRemove(byte[] data) {
        String key = (String)SerializationUtils.deserialize((byte[])data);
        log.trace("onRemove {} by key: {}", (Object)this.cacheKey, (Object)key);
        this.cache.invalidate((Object)key);
    }

    @Override
    public int onClear() {
        String idx = (String)this.props.CLOUD_APP_INSTANCE_INDEX.get();
        int size = this.size();
        log.debug("onClear {} items: {} on ({})", new Object[]{this.cacheKey, size, idx});
        this.cache.invalidateAll();
        return size;
    }

    protected void onPut(byte[] keyData, byte[] valueData) throws IOException {
        UnsynchronizedByteArrayInputStream kstream = UnsynchronizedByteArrayInputStream.builder().setByteArray(keyData).get();
        UnsynchronizedByteArrayInputStream vstream = UnsynchronizedByteArrayInputStream.builder().setByteArray(valueData).get();
        String key = (String)PlatformUtil.deserialize((UnsynchronizedByteArrayInputStream)kstream);
        switch (this.type()) {
            case NATURAL_KEY: {
                Object read = PlatformUtil.deserialize((UnsynchronizedByteArrayInputStream)vstream);
                this.cache.put((Object)key, read);
                break;
            }
            case BEAN: {
                try (ObjectInputStream ois = new ObjectInputStream((InputStream)vstream);){
                    CachedBeanData read = new CachedBeanData();
                    read.readExternal((ObjectInput)ois);
                    boolean toPut = true;
                    CachedBeanData current = (CachedBeanData)this.cache.getIfPresent((Object)key);
                    if (Objects.nonNull(current)) {
                        boolean bl = toPut = read.getVersion() > current.getVersion();
                    }
                    if (toPut) {
                        log.trace("onPut {} by key: {} bean value: {}", new Object[]{this.cacheKey, key, read});
                        this.cache.put((Object)key, (Object)read);
                    }
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case COLLECTION_IDS: {
                try (ObjectInputStream ois = new ObjectInputStream((InputStream)vstream);){
                    CachedManyIds read = new CachedManyIds();
                    read.readExternal((ObjectInput)ois);
                    log.trace("onPut {} by key: {} ids value: {}", new Object[]{this.cacheKey, key, read});
                    this.cache.put((Object)key, (Object)read);
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected cache type: " + String.valueOf(this.type()));
            }
        }
    }

    protected String key(Object key) {
        return this.tenantAwareKey.key(key).toString();
    }
}

