package com.turbospaces.ebean;

import java.io.IOException;
import java.util.Objects;

import com.turbospaces.cache.BlockhoundCacheWrapper;
import com.turbospaces.cfg.ApplicationProperties;

import io.ebean.cache.ServerCacheConfig;
import io.ebean.config.CurrentTenantProvider;

public class ReplicatedEbeanCache extends AbstractEbeanCache implements ReplicatedCache {
    private final BroadcastChannel dispatcher;

    public ReplicatedEbeanCache(
            ApplicationProperties props,
            String cacheKey,
            BlockhoundCacheWrapper<String, Object> cache,
            CurrentTenantProvider tenantProvider,
            ServerCacheConfig config,
            BroadcastChannel dispatcher) {
        super(props, cacheKey, cache, tenantProvider, config);
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }
    @Override
    public void put(Object id, Object obj) {
        String key = key(id);
        super.put(id, obj);
        dispatcher.broadcastPutAsync(cacheKey(), type(), key, obj);
    }
    @Override
    public void remove(Object id) {
        String key = key(id);
        super.remove(id);
        dispatcher.broadcastRemoveAsync(cacheKey(), key);
    }
    @Override
    public void clear() {
        super.clear();
        dispatcher.broadcastClearAllAsync();
    }
    @Override
    public void onRemove(byte[] data) {
        super.onRemove(data);
    }
    @Override
    public int onClear() {
        return super.onClear();
    }
    @Override
    public void onPut(byte[] keyData, byte[] valueData) throws IOException {
        super.onPut(keyData, valueData);
    }
}
