package com.turbospaces.ebean;

import java.util.Objects;

import com.turbospaces.cfg.ApplicationProperties;

import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class JgroupsServerQueryCache extends DefaultServerQueryCache implements ClearableCache {
    private final ApplicationProperties props;
    private final JGroupsBroadcastChannel dispatcher;

    public JgroupsServerQueryCache(ApplicationProperties props, DefaultServerCacheConfig config, JGroupsBroadcastChannel dispatcher) {
        super(config);
        this.props = Objects.requireNonNull(props);
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }
    @Override
    public void clear() {
        onClear();
        dispatcher.broadcastClearAllAsync(name);
    }
    @Override
    public int onClear() {
        String idx = props.CLOUD_APP_INSTANCE_INDEX.get();
        int size = size();
        log.info("onClear {}, items: {} on ({})", name, size, idx);
        super.clear();
        return size();
    }
}
