package com.turbospaces.ebean;

import java.util.Objects;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.config.AbstractFactoryBean;

import com.turbospaces.cfg.ApplicationProperties;

import io.micrometer.core.instrument.MeterRegistry;

public class JGroupCacheManagerFactoryBean extends AbstractFactoryBean<CacheManager> {
    private final ApplicationProperties props;
    private final MeterRegistry meterRegistry;
    private final JChannel jchannel;
    private final RpcDispatcher dispatcher = new RpcDispatcher();

    public JGroupCacheManagerFactoryBean(ApplicationProperties props, MeterRegistry meterRegistry, JChannel jchannel) {
        this.props = Objects.requireNonNull(props);
        this.meterRegistry = Objects.requireNonNull(meterRegistry);
        this.jchannel = Objects.requireNonNull(jchannel);
    }
    @Override
    public Class<?> getObjectType() {
        return CacheManager.class;
    }
    @Override
    protected CacheManager createInstance() throws Exception {
        for (;;) {
            try {
                JGroupsCacheManager manager = new JGroupsCacheManager(props, meterRegistry, dispatcher);
                manager.afterPropertiesSet();

                dispatcher.setAsynDispatching(true);
                dispatcher.setChannel(jchannel);
                dispatcher.setServerObject(manager);
                dispatcher.setMethodLookup(manager);
                dispatcher.start();

                return manager;
            } catch (Throwable err) {
                ExceptionUtils.wrapAndThrow(err);
            }
        }
    }
    @Override
    protected void destroyInstance(CacheManager instance) throws Exception {
        dispatcher.close();
    }
}
