package com.turbospaces.ebean;

import com.google.common.annotations.VisibleForTesting;

import io.ebean.BackgroundExecutor;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCachePlugin;

public interface CacheManager extends ServerCachePlugin, ServerCacheFactory {
    void setBackgroundExecutor(BackgroundExecutor executor);

    @VisibleForTesting
    ServerCache getCache(String string);

    void clearAll();

    default void onCachePut(String cacheKey, byte[] id, byte[] value) throws Throwable {}
    default void onCacheRemove(String cacheKey, byte[] id) throws Throwable {}
    default void onCacheClear(String cacheKey) throws Throwable {}
    default void onTablesModify(String tables) throws Throwable {}

    @Deprecated
    default void onCacheClearAll(boolean preserveSimple) throws Throwable {}
    default void onCacheClearAll() throws Throwable {
        onCacheClearAll(true);
    }
}
