/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.ebean.JGroupsCacheManager;
import com.turbospaces.ebean.LocalCache;
import com.turbospaces.ebean.ReplicatedCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.ServerCacheType;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedManyIds;
import io.vavr.CheckedFunction0;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class ReplicatedEbeanCache
extends AbstractBootstrapAware
implements ReplicatedCache {
    private final String cacheKey;
    private final RpcDispatcher dispatcher;
    private final LocalCache local;
    private final ServerCacheConfig config;

    public ReplicatedEbeanCache(String cacheKey, RpcDispatcher dispatcher, LocalCache local, ServerCacheConfig config) {
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.local = Objects.requireNonNull(local);
        this.config = Objects.requireNonNull(config);
    }

    public int size() {
        return this.local.size();
    }

    public Object get(Object id) {
        return this.local.get(id);
    }

    public int hitRatio() {
        return this.local.hitRatio();
    }

    public ServerCacheStatistics statistics(boolean reset) {
        return this.local.statistics(reset);
    }

    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }

    public void put(final Object id, final Object value) {
        this.local.put(id, value);
        final byte[] keyAsBytes = SerializationUtils.serialize((Serializable)((Serializable)id));
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        switch (this.config.getType()) {
            case NATURAL_KEY: {
                ObjectOutputStream oos;
                try {
                    oos = new ObjectOutputStream(out);
                    try {
                        oos.writeObject(value);
                        oos.flush();
                    }
                    finally {
                        oos.close();
                    }
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case BEAN: {
                ObjectOutputStream oos;
                try {
                    oos = new ObjectOutputStream(out);
                    try {
                        CachedBeanData data = (CachedBeanData)value;
                        data.writeExternal((ObjectOutput)oos);
                        oos.flush();
                    }
                    finally {
                        oos.close();
                    }
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case COLLECTION_IDS: {
                ObjectOutputStream oos;
                try {
                    oos = new ObjectOutputStream(out);
                    try {
                        CachedManyIds data = (CachedManyIds)value;
                        data.writeExternal((ObjectOutput)oos);
                        oos.flush();
                    }
                    finally {
                        oos.close();
                    }
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected cache type: " + this.config.getType());
            }
        }
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture.from((ListenableFuture)this.bootstrap.globalPlatform().submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (ReplicatedEbeanCache.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_PUT, new Object[]{ReplicatedEbeanCache.this.cacheKey, keyAsBytes, out.toByteArray()});
                    future = ReplicatedEbeanCache.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        })).addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                ReplicatedEbeanCache.this.logger.trace("putted {} entry on remote nodes by key: {} value: {} in: {}", new Object[]{ReplicatedEbeanCache.this.cacheKey, id, value, stopWatch});
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    ReplicatedEbeanCache.this.logger.error("put operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                ReplicatedEbeanCache.this.logger.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
    }

    public void remove(final Object id) {
        this.local.remove(id);
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture.from((ListenableFuture)this.bootstrap.globalPlatform().submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (ReplicatedEbeanCache.this.dispatcher.getChannel().isOpen()) {
                    byte[] keyAsBytes = SerializationUtils.serialize((Serializable)((Serializable)id));
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CHANGE_REMOVE, new Object[]{ReplicatedEbeanCache.this.cacheKey, keyAsBytes});
                    future = ReplicatedEbeanCache.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        })).addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                ReplicatedEbeanCache.this.logger.debug("removed {} entry on remote nodes by key: {} in: {}", new Object[]{ReplicatedEbeanCache.this.cacheKey, id, stopWatch});
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    ReplicatedEbeanCache.this.logger.error("remove operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                ReplicatedEbeanCache.this.logger.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
    }

    public void clear() {
        this.local.clear();
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture.from((ListenableFuture)this.bootstrap.globalPlatform().submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (ReplicatedEbeanCache.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_CLEAR, new Object[]{ReplicatedEbeanCache.this.cacheKey});
                    future = ReplicatedEbeanCache.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        })).addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                ReplicatedEbeanCache.this.logger.info("cleared {} on remote nodes in: {}", (Object)ReplicatedEbeanCache.this.cacheKey, (Object)stopWatch);
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    ReplicatedEbeanCache.this.logger.error("clear operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                ReplicatedEbeanCache.this.logger.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void onPut(byte[] keyData, byte[] valueData) {
        Object key = SerializationUtils.deserialize((byte[])keyData);
        ByteArrayInputStream is = new ByteArrayInputStream(valueData);
        switch (this.config.getType()) {
            case NATURAL_KEY: {
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    Object read = ois.readObject();
                    this.logger.trace("onPut {} by key: {} value: {}", new Object[]{this.cacheKey, key, read});
                    this.local.put(key, read);
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case BEAN: {
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    CachedBeanData read = new CachedBeanData();
                    read.readExternal((ObjectInput)ois);
                    boolean toPut = true;
                    CachedBeanData current = (CachedBeanData)this.local.get(key);
                    if (Objects.nonNull(current)) {
                        boolean bl = toPut = read.getVersion() > current.getVersion();
                    }
                    if (toPut) {
                        this.logger.trace("onPut {} by key: {} bean value: {}", new Object[]{this.cacheKey, key, read});
                        this.local.put(key, read);
                    }
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case COLLECTION_IDS: {
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    CachedManyIds read = new CachedManyIds();
                    read.readExternal((ObjectInput)ois);
                    this.logger.trace("onPut {} by key: {} ids value: {}", new Object[]{this.cacheKey, key, read});
                    this.local.put(key, read);
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected cache type: " + this.config.getType());
            }
        }
    }

    @Override
    public void onRemove(byte[] data) {
        Object key = SerializationUtils.deserialize((byte[])data);
        this.logger.debug("onRemove {} by key: {}", (Object)this.cacheKey, key);
        this.local.remove(key);
    }

    @Override
    public int onClear() {
        String idx = (String)this.bootstrap.props().CLOUD_APP_INSTANCE_INDEX.get();
        int size = this.local.size();
        this.logger.info("onClear {} items: {} on ({})", new Object[]{this.cacheKey, size, idx});
        this.local.clear();
        return size;
    }

    @Override
    public void cleanUp() {
        this.local.cleanUp();
    }

    @Override
    public ServerCacheType type() {
        return this.config.getType();
    }
}

